/*
 * Decompiled with CFR 0.152.
 */
package basemod;

import basemod.ClickableUIElement;
import basemod.TopPanelArrow;
import basemod.TopPanelItem;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import java.util.ArrayList;

public class TopPanelGroup {
    private static final int pageItemCount = 3;
    private static final float X_POS = 1667.0f;
    private static final float Y_POS = -64.0f;
    private ArrayList<TopPanelItem> topPanelItems;
    private ArrayList<TopPanelItem> activePanelItems;
    private ClickableUIElement leftArrow;
    private ClickableUIElement rightArrow;
    private int currentPage = 1;

    public TopPanelGroup(ArrayList<TopPanelItem> topPanelItems) {
        this.topPanelItems = topPanelItems;
        this.initArrows();
    }

    public void addPanelItem(TopPanelItem panelItem) {
        this.topPanelItems.add(panelItem);
    }

    public void removePanelItem(TopPanelItem panelItem) {
        this.topPanelItems.remove(panelItem);
    }

    public int size() {
        return this.topPanelItems.size();
    }

    public void render(SpriteBatch sb) {
        this.renderArrows(sb);
        this.renderItems(sb);
    }

    public void update() {
        int endIndex = this.currentPage * 3;
        int startIndex = endIndex - 3;
        this.activePanelItems = new ArrayList<TopPanelItem>(this.topPanelItems.subList(startIndex, endIndex > this.topPanelItems.size() ? this.topPanelItems.size() : endIndex));
        this.updateArrows();
        this.updateItems();
    }

    private void updateItems() {
        float xpos = 1667.0f * Settings.scale;
        for (int i = this.activePanelItems.size() - 1; i >= 0; --i) {
            TopPanelItem temp = this.activePanelItems.get(i);
            temp.setX(xpos -= temp.hb_w);
            temp.setY(-64.0f * Settings.scale);
            temp.update();
        }
    }

    private void renderItems(SpriteBatch sb) {
        if (this.activePanelItems == null) {
            return;
        }
        for (int i = 0; i < this.activePanelItems.size(); ++i) {
            this.activePanelItems.get(i).render(sb);
        }
    }

    private void updateArrows() {
        if (this.currentPage != 1) {
            this.leftArrow.update();
        }
        if (this.currentPage < (int)Math.ceil((float)this.topPanelItems.size() / 3.0f)) {
            this.rightArrow.update();
        }
    }

    private void renderArrows(SpriteBatch sb) {
        if (this.currentPage != 1) {
            this.leftArrow.render(sb);
        }
        if (this.currentPage < (int)Math.ceil((float)this.topPanelItems.size() / 3.0f)) {
            this.rightArrow.render(sb);
        }
    }

    private void initArrows() {
        float lX = 1435.0f;
        float rX = 1660.0f;
        float y = -54.0f;
        this.leftArrow = new TopPanelArrow(ImageMaster.loadImage((String)"img/tinyLeftArrow.png"), lX, y, 32.0f, 32.0f){

            @Override
            protected void onClick() {
                if (TopPanelGroup.this.currentPage != 1) {
                    TopPanelGroup.this.currentPage--;
                }
            }
        };
        this.rightArrow = new TopPanelArrow(ImageMaster.loadImage((String)"img/tinyRightArrow.png"), rX, y, 32.0f, 32.0f){

            @Override
            protected void onClick() {
                if (TopPanelGroup.this.currentPage < (int)Math.ceil((float)TopPanelGroup.this.topPanelItems.size() / 3.0f)) {
                    TopPanelGroup.this.currentPage++;
                }
            }
        };
    }
}

