/*
 * Decompiled with CFR 0.152.
 */
package basemod;

import basemod.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReflectionHacks {
    public static final Logger logger = LogManager.getLogger((String)ReflectionHacks.class.getName());
    private static final Map<Pair<Class<?>, String>, Field> fieldMap = new HashMap();
    private static final Map<String, Method> methodMap = new HashMap<String, Method>();

    private ReflectionHacks() {
    }

    private static String toDescriptor(Class<?> clz, String methodName, Class<?> ... parameterTypes) {
        StringBuilder buf = new StringBuilder();
        buf.append(clz.getName().replace('.', '/')).append('.').append(methodName).append(":(");
        for (Class<?> paramType : parameterTypes) {
            ReflectionHacks.toDescriptor(buf, paramType);
        }
        buf.append(')');
        return buf.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void toDescriptor(StringBuilder buf, Class<?> clz) {
        if (clz.isPrimitive()) {
            if (clz == Byte.TYPE) {
                buf.append('B');
                return;
            } else if (clz == Character.TYPE) {
                buf.append('C');
                return;
            } else if (clz == Float.TYPE) {
                buf.append('F');
                return;
            } else if (clz == Double.TYPE) {
                buf.append('D');
                return;
            } else if (clz == Integer.TYPE) {
                buf.append('I');
                return;
            } else if (clz == Long.TYPE) {
                buf.append('J');
                return;
            } else if (clz == Short.TYPE) {
                buf.append('S');
                return;
            } else if (clz == Boolean.TYPE) {
                buf.append('Z');
                return;
            } else {
                if (clz != Void.TYPE) throw new RuntimeException("Unrecognized primitive " + clz);
                buf.append('V');
            }
            return;
        } else if (clz.isArray()) {
            buf.append('[');
            ReflectionHacks.toDescriptor(buf, clz.getComponentType());
            return;
        } else {
            buf.append('L').append(clz.getName().replace('.', '/')).append(';');
        }
    }

    public static Field getCachedField(Class<?> clz, String fieldName) {
        Pair pair = new Pair(clz, fieldName);
        Field ret = fieldMap.get(pair);
        if (ret == null) {
            try {
                ret = clz.getDeclaredField(fieldName);
                ret.setAccessible(true);
                fieldMap.put(pair, ret);
            }
            catch (NoSuchFieldException e) {
                logger.error("Exception occurred when getting field " + fieldName + " of " + clz.getName(), (Throwable)e);
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static Method getCachedMethod(Class<?> clz, String methodName, Class<?> ... parameterTypes) {
        String descriptor = ReflectionHacks.toDescriptor(clz, methodName, parameterTypes);
        Method ret = methodMap.get(descriptor);
        if (ret == null) {
            try {
                ret = clz.getDeclaredMethod(methodName, parameterTypes);
                ret.setAccessible(true);
                methodMap.put(descriptor, ret);
            }
            catch (NoSuchMethodException e) {
                logger.error("Exception occurred when getting method " + methodName + " of " + clz.getName(), (Throwable)e);
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static <T> T getPrivateStatic(Class<?> objClass, String fieldName) {
        try {
            return (T)ReflectionHacks.getCachedField(objClass, fieldName).get(null);
        }
        catch (Exception e) {
            logger.error("Exception occurred when getting private static field " + fieldName + " of " + objClass.getName(), (Throwable)e);
            return null;
        }
    }

    public static void setPrivateStatic(Class<?> objClass, String fieldName, Object newValue) {
        try {
            ReflectionHacks.getCachedField(objClass, fieldName).set(null, newValue);
        }
        catch (Exception e) {
            logger.error("Exception occurred when setting private static field " + fieldName + " of " + objClass.getName(), (Throwable)e);
        }
    }

    public static void setPrivateStaticFinal(Class<?> objClass, String fieldName, Object newValue) {
        try {
            Field f = ReflectionHacks.getCachedField(objClass, fieldName);
            Field modifiers = ReflectionHacks.getCachedField(Field.class, "modifiers");
            modifiers.setInt(f, f.getModifiers() & 0xFFFFFFEF);
            f.set(null, newValue);
            modifiers.setInt(f, f.getModifiers() & 0x10);
        }
        catch (Exception e) {
            logger.error("Exception occurred when setting private static (final) field " + fieldName + " of " + objClass.getName(), (Throwable)e);
        }
    }

    public static <T> T getPrivate(Object obj, Class<?> objClass, String fieldName) {
        try {
            return (T)ReflectionHacks.getCachedField(objClass, fieldName).get(obj);
        }
        catch (Exception e) {
            logger.error("Exception occurred when getting private field " + fieldName + " of " + objClass.getName(), (Throwable)e);
            return null;
        }
    }

    public static void setPrivate(Object obj, Class<?> objClass, String fieldName, Object newValue) {
        try {
            ReflectionHacks.getCachedField(objClass, fieldName).set(obj, newValue);
        }
        catch (Exception e) {
            logger.error("Exception occurred when setting private field " + fieldName + " of " + objClass.getName(), (Throwable)e);
        }
    }

    public static void setPrivateFinal(Object obj, Class<?> objClass, String fieldName, Object newValue) {
        try {
            Field f = ReflectionHacks.getCachedField(objClass, fieldName);
            Field modifiers = ReflectionHacks.getCachedField(Field.class, "modifiers");
            modifiers.setInt(f, f.getModifiers() & 0xFFFFFFEF);
            f.set(obj, newValue);
            modifiers.setInt(f, f.getModifiers() & 0x10);
        }
        catch (Exception e) {
            logger.error("Exception occurred when setting private (final) field " + fieldName + " of " + objClass.getName(), (Throwable)e);
        }
    }

    public static <T> T getPrivateInherited(Object obj, Class<?> objClass, String fieldName) {
        for (objClass = objClass.getSuperclass(); objClass != null && objClass != Object.class; objClass = objClass.getSuperclass()) {
            try {
                Field f = objClass.getDeclaredField(fieldName);
                f.setAccessible(true);
                try {
                    return (T)f.get(obj);
                }
                catch (IllegalAccessException e) {
                    logger.error("Exception occurred when getting private field " + fieldName + " of the superclass of " + objClass.getName(), (Throwable)e);
                    return null;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static void setPrivateInherited(Object obj, Class<?> objClass, String fieldName, Object newValue) {
        for (objClass = objClass.getSuperclass(); objClass != null && objClass != Object.class; objClass = objClass.getSuperclass()) {
            try {
                Field f = objClass.getDeclaredField(fieldName);
                f.setAccessible(true);
                try {
                    f.set(obj, newValue);
                }
                catch (IllegalAccessException e) {
                    logger.error("Exception occurred when setting private field " + fieldName + " of the superclass of " + objClass.getName(), (Throwable)e);
                }
                return;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
    }

    public static RMethod privateMethod(Class<?> objClass, String methodName, Class<?> ... parameterTypes) {
        return new RMethod((Class)objClass, methodName, (Class[])parameterTypes);
    }

    public static RStaticMethod privateStaticMethod(Class<?> objClass, String methodName, Class<?> ... parameterTypes) {
        return new RStaticMethod((Class)objClass, methodName, (Class[])parameterTypes);
    }

    public static class RStaticMethod
    extends RMethod {
        private RStaticMethod(Class<?> clz, String methodName, Class<?> ... parameterTypes) {
            super((Class)clz, methodName, (Class[])parameterTypes);
        }

        public <R> R invoke(Object ... args) {
            return super.invoke(null, args);
        }
    }

    public static class RMethod {
        private final Method method;

        private RMethod(Class<?> clz, String methodName, Class<?> ... parameterTypes) {
            this.method = ReflectionHacks.getCachedMethod(clz, methodName, parameterTypes);
        }

        public <R> R invoke(Object instance, Object ... args) {
            try {
                return (R)this.method.invoke(instance, args);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

