/*
 * Decompiled with CFR 0.152.
 */
package basemod;

import basemod.IUIElement;
import basemod.ModPanel;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.helpers.input.InputHelper;
import java.util.function.Consumer;

public class ModMinMaxSlider
implements IUIElement {
    private static final float L_X = 1235.0f * Settings.scale;
    private static final float SLIDE_W = 230.0f * Settings.scale;
    private Consumer<ModMinMaxSlider> change;
    private Hitbox hb;
    private Hitbox bgHb;
    private float x;
    private float sliderX;
    private float handleX;
    private float y;
    private boolean sliderGrabbed = false;
    private String label;
    private String format;
    private float value;
    private float minValue;
    private float maxValue;
    public ModPanel parent;

    public ModMinMaxSlider(String lbl, float posX, float posY, float min, float max, float val, String format, ModPanel p, Consumer<ModMinMaxSlider> changeAction) {
        this.label = lbl;
        this.format = format == null || format.isEmpty() ? "%.2f" : format;
        this.minValue = min;
        this.maxValue = max;
        this.parent = p;
        this.change = changeAction;
        posX = posX == -1.0f ? L_X : (posX *= Settings.scale);
        this.x = posX;
        this.sliderX = this.x - 11.0f * Settings.scale;
        this.handleX = this.x + SLIDE_W;
        this.y = posY * Settings.scale;
        this.hb = new Hitbox(42.0f * Settings.scale, 38.0f * Settings.scale);
        this.bgHb = new Hitbox(300.0f * Settings.scale, 38.0f * Settings.scale);
        this.bgHb.move(this.sliderX + SLIDE_W / 2.0f, this.y);
        this.setValue(val);
    }

    @Override
    public void render(SpriteBatch sb) {
        sb.setColor(Color.WHITE);
        sb.draw(ImageMaster.OPTION_SLIDER_BG, this.sliderX, this.y - 12.0f, 0.0f, 12.0f, 250.0f, 24.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 250, 24, false, false);
        sb.draw(ImageMaster.OPTION_SLIDER, this.handleX - 22.0f, this.y - 22.0f, 22.0f, 22.0f, 44.0f, 44.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 44, 44, false, false);
        FontHelper.renderFontCentered((SpriteBatch)sb, (BitmapFont)FontHelper.tipBodyFont, (String)this.label, (float)(this.sliderX - 55.0f * Settings.scale), (float)this.y, (Color)Color.WHITE);
        String renderVal = String.format(this.format, Float.valueOf(this.getValue()));
        if (this.sliderGrabbed) {
            FontHelper.renderFontCentered((SpriteBatch)sb, (BitmapFont)FontHelper.tipBodyFont, (String)renderVal, (float)(this.sliderX + SLIDE_W + 55.0f * Settings.scale), (float)this.y, (Color)Settings.GREEN_TEXT_COLOR);
        } else {
            FontHelper.renderFontCentered((SpriteBatch)sb, (BitmapFont)FontHelper.tipBodyFont, (String)renderVal, (float)(this.sliderX + SLIDE_W + 55.0f * Settings.scale), (float)this.y, (Color)Settings.BLUE_TEXT_COLOR);
        }
        this.hb.render(sb);
        this.bgHb.render(sb);
    }

    @Override
    public void update() {
        this.hb.update();
        this.bgHb.update();
        this.hb.move(this.handleX, this.y);
        if (this.sliderGrabbed) {
            if (InputHelper.isMouseDown) {
                this.handleX = MathHelper.fadeLerpSnap((float)this.handleX, (float)InputHelper.mX);
                this.handleX = Math.min(this.sliderX + SLIDE_W + 11.0f * Settings.scale, Math.max(this.handleX, this.sliderX + 11.0f * Settings.scale));
            } else {
                this.sliderGrabbed = false;
            }
        } else if (InputHelper.justClickedLeft && (this.hb.hovered || this.bgHb.hovered)) {
            this.sliderGrabbed = true;
        }
        float oldVal = this.getValue();
        this.value = (this.handleX - 11.0f * Settings.scale - this.sliderX) / SLIDE_W;
        if (oldVal != this.getValue()) {
            this.onChange();
        }
    }

    public float getValue() {
        return this.value * (this.maxValue - this.minValue) + this.minValue;
    }

    public void setValue(float val) {
        if (val < this.minValue) {
            val = this.minValue;
        } else if (val > this.maxValue) {
            val = this.maxValue;
        }
        this.value = val = (val - this.minValue) / (this.maxValue - this.minValue);
        this.handleX = this.sliderX + SLIDE_W * val + 11.0f * Settings.scale;
    }

    private void onChange() {
        this.change.accept(this);
    }

    @Override
    public int renderLayer() {
        return 1;
    }

    @Override
    public int updateOrder() {
        return 1;
    }

    @Override
    public void set(float xPos, float yPos) {
        this.handleX += (xPos *= Settings.scale) - this.x;
        this.x = xPos;
        this.sliderX = this.x - 11.0f * Settings.scale;
        this.y = yPos * Settings.scale;
        this.bgHb.move(this.sliderX + SLIDE_W / 2.0f, this.y);
    }

    @Override
    public void setX(float xPos) {
        this.set(xPos, this.y / Settings.scale);
    }

    @Override
    public void setY(float yPos) {
        this.set(this.x / Settings.scale, yPos);
    }

    @Override
    public float getX() {
        return this.x / Settings.scale;
    }

    @Override
    public float getY() {
        return this.y / Settings.scale;
    }
}

