/*
 * Decompiled with CFR 0.152.
 */
package basemod;

import basemod.AutoComplete;
import basemod.BaseMod;
import basemod.devcommands.ConsoleCommand;
import basemod.interfaces.PostEnergyRechargeSubscriber;
import basemod.interfaces.PostInitializeSubscriber;
import basemod.interfaces.PostRenderSubscriber;
import basemod.interfaces.PostUpdateSubscriber;
import basemod.interfaces.TextReceiver;
import basemod.patches.com.megacrit.cardcrawl.helpers.input.ScrollInputProcessor.TextInput;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.evacipated.cardcrawl.modthespire.lib.SpireConfig;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.ui.panels.EnergyPanel;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DevConsole
implements PostEnergyRechargeSubscriber,
PostInitializeSubscriber,
PostRenderSubscriber,
PostUpdateSubscriber,
TextReceiver {
    public static final Logger logger = LogManager.getLogger((String)DevConsole.class.getName());
    private static final int HISTORY_SIZE = 10;
    public static final float CONSOLE_X = 200.0f;
    public static final float CONSOLE_Y = 200.0f;
    public static final float CONSOLE_W = 800.0f;
    public static final float CONSOLE_H = 40.0f;
    public static final float CONSOLE_PAD_X = 15.0f;
    public static final int CONSOLE_TEXT_SIZE = 30;
    private static final int MAX_LINES = 8;
    public static final String PATTERN = "[\\s]+";
    public static final String PROMPT = "$> ";
    public static BitmapFont consoleFont = null;
    public static Texture consoleBackground = null;
    public static boolean infiniteEnergy = false;
    public static boolean forceUnlocks = false;
    public static int unlockLevel = -1;
    public static boolean enabled = false;
    public static boolean visible = false;
    public static int toggleKey = 68;
    public static String currentText = "";
    private static boolean wasBackspace = false;
    public static int priorKey = 19;
    public static int nextKey = 20;
    public static PriorCommandsList priorCommands;
    public static ArrayList<String> log;
    public static ArrayList<Boolean> prompted;
    public static int commandPos;

    public DevConsole() {
        BaseMod.subscribe(this);
        priorCommands = new PriorCommandsList();
        commandPos = -1;
        log = new ArrayList<String>(priorCommands);
        prompted = new ArrayList<Boolean>(Collections.nCopies(log.size(), true));
        AutoComplete.init();
        ConsoleCommand.initialize();
    }

    public static void execute() {
        String[] tokens = currentText.trim().split(PATTERN);
        if (priorCommands.size() == 0 || !((String)priorCommands.get(0)).equals(currentText)) {
            priorCommands.add(0, currentText);
        }
        log.add(0, currentText);
        prompted.add(0, true);
        commandPos = -1;
        currentText = "";
        if (tokens.length < 1) {
            return;
        }
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
        }
        ConsoleCommand.execute(tokens);
    }

    public static void couldNotParse() {
        DevConsole.log("could not parse previous command");
    }

    @Override
    public void receivePostEnergyRecharge() {
        if (infiniteEnergy) {
            EnergyPanel.setEnergy((int)9999);
        }
    }

    @Override
    public void receivePostInitialize() {
        FreeTypeFontGenerator generator = new FreeTypeFontGenerator(Gdx.files.internal("font/Kreon-Regular.ttf"));
        FreeTypeFontGenerator.FreeTypeFontParameter parameter = new FreeTypeFontGenerator.FreeTypeFontParameter();
        parameter.size = (int)(30.0f * Settings.scale);
        consoleFont = generator.generateFont(parameter);
        generator.dispose();
        consoleBackground = ImageMaster.loadImage((String)"img/ConsoleBackground.png");
        AutoComplete.postInit();
    }

    public static void log(String text) {
        log.add(0, text);
        prompted.add(0, false);
    }

    public static void log(Collection<?> list) {
        for (Object o : list) {
            DevConsole.log(o.toString());
        }
    }

    @Override
    public void receivePostRender(SpriteBatch sb) {
        if (visible && consoleFont != null) {
            int sizeToDraw = log.size() + 1;
            if (sizeToDraw > 8) {
                sizeToDraw = 8;
            }
            sb.draw(consoleBackground, 200.0f * Settings.scale, 200.0f * Settings.scale, 800.0f * Settings.scale, 40.0f * Settings.scale + 30.0f * Settings.scale * (float)(sizeToDraw - 1));
            if (AutoComplete.enabled) {
                AutoComplete.render(sb);
            }
            float x = 200.0f * Settings.scale + 15.0f * Settings.scale;
            float y = 200.0f * Settings.scale + (float)Math.floor(30.0f * Settings.scale);
            consoleFont.draw((Batch)sb, (CharSequence)(PROMPT + currentText), x, y);
            for (int i = 0; i < sizeToDraw - 1; ++i) {
                consoleFont.draw((Batch)sb, (CharSequence)((prompted.get(i) != false ? PROMPT : "") + log.get(i)), x, y += (float)Math.floor(30.0f * Settings.scale));
            }
        }
    }

    @Override
    public String getCurrentText() {
        return currentText;
    }

    @Override
    public void setText(String updatedText) {
        currentText = updatedText;
        AutoComplete.suggest(wasBackspace);
        wasBackspace = false;
    }

    @Override
    public boolean onPushBackspace() {
        wasBackspace = true;
        return false;
    }

    @Override
    public boolean acceptCharacter(char c) {
        return consoleFont.getData().hasGlyph(c) && (Input.Keys.toString((int)toggleKey) == null || !Input.Keys.toString((int)toggleKey).equals("" + c));
    }

    @Override
    public boolean onKeyUp(int keycode) {
        if (keycode == 66) {
            if (currentText.length() > 0) {
                DevConsole.execute();
                if (AutoComplete.enabled) {
                    AutoComplete.reset();
                    AutoComplete.suggest(false);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onKeyDown(int keycode) {
        if (AutoComplete.enabled) {
            if (keycode == priorKey) {
                if (Gdx.input.isKeyPressed(AutoComplete.selectKey)) {
                    AutoComplete.selectUp();
                } else if (commandPos + 1 < priorCommands.size()) {
                    currentText = (String)priorCommands.get(++commandPos);
                    AutoComplete.resetAndSuggest();
                }
                return true;
            }
            if (keycode == nextKey) {
                if (Gdx.input.isKeyPressed(AutoComplete.selectKey)) {
                    AutoComplete.selectDown();
                } else {
                    if (commandPos - 1 < 0) {
                        currentText = "";
                        commandPos = -1;
                    } else {
                        currentText = (String)priorCommands.get(--commandPos);
                    }
                    AutoComplete.resetAndSuggest();
                }
                return true;
            }
            if (keycode == AutoComplete.fillKey1 || keycode == AutoComplete.fillKey2) {
                AutoComplete.fillInSuggestion();
                return true;
            }
            if (keycode == AutoComplete.deleteTokenKey) {
                AutoComplete.removeOneTokenUsingSpaceAndIdDelimiter();
                if (AutoComplete.enabled) {
                    AutoComplete.suggest(false);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void receivePostUpdate() {
        if (enabled && Gdx.input.isKeyJustPressed(toggleKey)) {
            AutoComplete.reset();
            if (visible) {
                currentText = "";
                commandPos = -1;
                TextInput.stopTextReceiver(this);
            } else if (enabled) {
                TextInput.startTextReceiver(this);
                if (AutoComplete.enabled) {
                    AutoComplete.suggest(false);
                }
            }
            visible = !visible;
        }
    }

    @Override
    public boolean isDone() {
        return !visible;
    }

    public static class PriorCommandsList
    extends ArrayList<String> {
        private static final String HISTORY_LOCATION = SpireConfig.makeFilePath((String)"BaseMod", (String)"console-history", (String)"txt");

        public PriorCommandsList() {
            try {
                List<String> list = Files.readAllLines(Paths.get(HISTORY_LOCATION, new String[0]), StandardCharsets.UTF_8);
                this.addAll(list);
            }
            catch (IOException e) {
                logger.error("Failed to load dev console history: " + e);
            }
        }

        private void saveHistory() {
            try {
                Files.write(Paths.get(HISTORY_LOCATION, new String[0]), this.subList(0, Math.min(10, this.size())), StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                logger.error("Failed to save dev console history: " + e);
            }
        }

        @Override
        public boolean add(String s) {
            boolean ret = super.add(s);
            this.saveHistory();
            return ret;
        }

        @Override
        public void add(int index, String element) {
            super.add(index, element);
            this.saveHistory();
        }

        @Override
        public void clear() {
            super.clear();
            this.saveHistory();
        }
    }
}

