/*
 * Decompiled with CFR 0.152.
 */
package basemod;

import basemod.ClickableUIElement;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.daily.DailyScreen;
import com.megacrit.cardcrawl.daily.mods.AbstractDailyMod;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.TipHelper;
import com.megacrit.cardcrawl.helpers.input.InputHelper;
import java.util.ArrayList;

public class DailyModsDropdown
extends ClickableUIElement {
    private ArrayList<AbstractDailyMod> dailyMods;
    private ArrayList<DailyModIcon> dailyModIcons;
    private boolean showModList = false;
    private String text;
    private final float SHADOW_DIST_X = 9.0f * Settings.scale;
    private final float SHADOW_DIST_Y = 14.0f * Settings.scale;
    private final float BOX_EDGE_H = 32.0f * Settings.scale;
    private final float BOX_BODY_H = 64.0f * Settings.scale;
    private final float BOX_W = 104.0f * Settings.scale;
    private final float TEXT_OFFSET_X = 22.0f * Settings.scale;
    private final float TOP_OFFSET_Y = 12.0f * Settings.scale;

    public DailyModsDropdown(ArrayList<AbstractDailyMod> dailyMods, float x, float y) {
        super((Texture)null, x, y, 110.0f, 64.0f);
        this.dailyMods = dailyMods;
        this.dailyModIcons = new ArrayList();
        this.setX(x * Settings.scale);
        if (y < 0.0f) {
            this.setY((float)Settings.HEIGHT + y * Settings.scale);
        } else {
            this.setY(y * Settings.scale);
        }
        this.initDailyModIcons();
        this.text = DailyScreen.TEXT[13].trim();
        if (this.text.endsWith(":")) {
            this.text = this.text.substring(0, this.text.length() - 1);
        }
    }

    @Override
    public void update() {
        super.update();
        if (!this.hitbox.hovered && InputHelper.justClickedLeft) {
            this.showModList = false;
        }
        if (this.showModList) {
            this.dailyModIcons.forEach(ClickableUIElement::update);
        }
    }

    @Override
    public void render(SpriteBatch sb) {
        super.render(sb);
        sb.setColor(Color.WHITE);
        if (this.hitbox.hovered) {
            FontHelper.renderFontCenteredHeight((SpriteBatch)sb, (BitmapFont)FontHelper.tipBodyFont, (String)this.text, (float)this.x, (float)(this.y + this.hb_h / 2.0f), (Color)Settings.GOLD_COLOR.cpy().lerp(Color.WHITE, 0.3f));
        } else {
            FontHelper.renderFontCenteredHeight((SpriteBatch)sb, (BitmapFont)FontHelper.tipBodyFont, (String)this.text, (float)this.x, (float)(this.y + this.hb_h / 2.0f), (Color)Settings.GOLD_COLOR);
        }
        if (this.showModList) {
            this.renderBox(sb, this.y - 60.0f * Settings.scale);
            this.dailyModIcons.forEach(mod -> mod.render(sb));
        }
        this.renderHitbox(sb);
    }

    @Override
    protected void onHover() {
    }

    @Override
    protected void onUnhover() {
    }

    @Override
    protected void onClick() {
        this.showModList = !this.showModList;
    }

    private void initDailyModIcons() {
        int count = 0;
        for (AbstractDailyMod dailyMod : this.dailyMods) {
            float yPos = this.y - this.TOP_OFFSET_Y - (float)count * 64.0f * Settings.scale - 31.0f * Settings.scale;
            DailyModIcon icon = new DailyModIcon(dailyMod.img, this.x + this.TEXT_OFFSET_X, yPos, 64.0f, 64.0f, dailyMod);
            this.dailyModIcons.add(icon);
            ++count;
        }
    }

    private void renderBox(SpriteBatch sb, float y) {
        float h = this.getImagesHeight();
        sb.setColor(Settings.TOP_PANEL_SHADOW_COLOR);
        sb.draw(ImageMaster.KEYWORD_TOP, this.x + this.SHADOW_DIST_X, y - this.SHADOW_DIST_Y, this.BOX_W, this.BOX_EDGE_H);
        sb.draw(ImageMaster.KEYWORD_BODY, this.x + this.SHADOW_DIST_X, y - h - this.BOX_EDGE_H - this.SHADOW_DIST_Y, this.BOX_W, h + this.BOX_EDGE_H);
        sb.draw(ImageMaster.KEYWORD_BOT, this.x + this.SHADOW_DIST_X, y - h - this.BOX_BODY_H - this.SHADOW_DIST_Y, this.BOX_W, this.BOX_EDGE_H);
        sb.setColor(Color.WHITE);
        sb.draw(ImageMaster.KEYWORD_TOP, this.x, y, this.BOX_W, this.BOX_EDGE_H);
        sb.draw(ImageMaster.KEYWORD_BODY, this.x, y - h - this.BOX_EDGE_H, this.BOX_W, h + this.BOX_EDGE_H);
        sb.draw(ImageMaster.KEYWORD_BOT, this.x, y - h - this.BOX_BODY_H, this.BOX_W, this.BOX_EDGE_H);
    }

    private float getImagesHeight() {
        return (float)(this.dailyMods.size() - 1) * 64.0f * Settings.scale;
    }

    private class DailyModIcon
    extends ClickableUIElement {
        private AbstractDailyMod dailyMod;

        public DailyModIcon(Texture image, float x, float y, float hb_w, float hb_h, AbstractDailyMod dailyMod) {
            super(image, x, y, hb_w, hb_h);
            this.dailyMod = dailyMod;
            this.y = y - 64.0f * Settings.scale;
            this.x = x;
            this.hitbox.move(this.x + this.hb_w / 2.0f, this.y + this.hb_h / 2.0f);
        }

        @Override
        protected void onHover() {
            TipHelper.renderGenericTip((float)(this.x + this.hb_w + 15.0f * Settings.scale), (float)this.y, (String)this.dailyMod.name, (String)this.dailyMod.description);
        }

        @Override
        protected void onUnhover() {
        }

        @Override
        protected void onClick() {
        }
    }
}

