/*
 * Decompiled with CFR 0.152.
 */
package basemod;

import basemod.BaseMod;
import basemod.IUIElement;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.input.InputHelper;
import com.megacrit.cardcrawl.screens.charSelect.CharacterOption;
import com.megacrit.cardcrawl.screens.charSelect.CharacterSelectScreen;
import java.util.ArrayList;

public class CustomCharacterSelectScreen
extends CharacterSelectScreen {
    private int optionsPerIndex = 4;
    private int selectIndex = 0;
    private int maxSelectIndex;
    private int optionsIndex;
    private LeftOptionsButton leftArrow = new LeftOptionsButton("images/ui/popupArrow.png", (int)(425.0f * Settings.scale), (int)((float)(Settings.isFourByThree ? 244 : 180) * Settings.scale));
    private RightOptionsButton rightArrow = new RightOptionsButton("images/ui/popupArrow.png", (int)(1425.0f * Settings.scale), (int)((float)(Settings.isFourByThree ? 244 : 180) * Settings.scale));
    private ArrayList<CharacterOption> allOptions;

    public CustomCharacterSelectScreen() {
        this.updateOptionsIndex();
        this.allOptions = new ArrayList();
    }

    public void initialize() {
        super.initialize();
        this.allOptions.clear();
        for (CharacterOption option : BaseMod.generateCharacterOptions()) {
            this.options.add(option);
        }
        for (CharacterOption option : this.options) {
            this.allOptions.add(option);
        }
        if (this.allOptions.size() == this.optionsPerIndex + 1) {
            ++this.optionsPerIndex;
        }
        this.selectIndex = 0;
        this.updateOptionsIndex();
        this.maxSelectIndex = (int)Math.ceil((float)this.allOptions.size() / (float)this.optionsPerIndex) - 1;
        this.options = new ArrayList<CharacterOption>(this.allOptions.subList(0, Math.min(this.optionsPerIndex, this.allOptions.size())));
        this.positionButtons();
    }

    public void render(SpriteBatch sb) {
        super.render(sb);
        if (this.selectIndex < this.maxSelectIndex) {
            this.rightArrow.render(sb);
        }
        if (this.selectIndex != 0) {
            this.leftArrow.render(sb);
        }
    }

    public void update() {
        super.update();
        if (this.selectIndex < this.maxSelectIndex) {
            this.rightArrow.update();
        }
        if (this.selectIndex != 0) {
            this.leftArrow.update();
        }
    }

    private void positionButtons() {
        int count = this.options.size();
        float offsetX = (float)Settings.WIDTH / 2.0f - (float)this.optionsPerIndex / 2.0f * 220.0f * Settings.scale + 110.0f * Settings.scale;
        for (int i = 0; i < count; ++i) {
            ((CharacterOption)this.options.get((int)i)).hb.move(offsetX + (float)i * 220.0f * Settings.scale, (Settings.isFourByThree ? 254.0f : 190.0f) * Settings.scale);
        }
        this.leftArrow.move(offsetX - 220.0f * Settings.scale, (Settings.isFourByThree ? 254.0f : 190.0f) * Settings.scale);
        this.rightArrow.move(offsetX + (float)count * 220.0f * Settings.scale, (Settings.isFourByThree ? 254.0f : 190.0f) * Settings.scale);
    }

    private void setCurrentOptions(boolean rightClicked) {
        if (rightClicked && this.selectIndex < this.maxSelectIndex) {
            ++this.selectIndex;
        } else if (!rightClicked && this.selectIndex > 0) {
            --this.selectIndex;
        }
        this.updateOptionsIndex();
        int endIndex = this.optionsIndex + this.optionsPerIndex;
        this.options = new ArrayList<CharacterOption>(this.allOptions.subList(this.optionsIndex, Math.min(this.allOptions.size(), endIndex)));
        this.options.forEach(o -> {
            o.selected = false;
        });
        this.positionButtons();
    }

    private void updateOptionsIndex() {
        this.optionsIndex = this.optionsPerIndex * this.selectIndex;
    }

    private class RightOptionsButton
    implements IUIElement {
        private Texture arrow;
        private int x;
        private int y;
        private int w;
        private int h;
        private Hitbox hitbox;

        public RightOptionsButton(String imgUrl, int x, int y) {
            this.arrow = ImageMaster.loadImage((String)imgUrl);
            this.x = x;
            this.y = y;
            this.w = (int)(Settings.scale * (float)this.arrow.getWidth() / 2.0f);
            this.h = (int)(Settings.scale * (float)this.arrow.getHeight() / 2.0f);
            this.hitbox = new Hitbox((float)x, (float)y, (float)this.w, (float)this.h);
        }

        public void move(float newX, float newY) {
            this.x = (int)(newX - (float)this.w / 2.0f);
            this.y = (int)(newY - (float)this.h / 2.0f);
            this.hitbox.move(newX, newY);
        }

        @Override
        public void render(SpriteBatch sb) {
            if (this.hitbox.hovered) {
                sb.setColor(Color.WHITE);
            } else {
                sb.setColor(Color.LIGHT_GRAY);
            }
            float halfW = (float)this.arrow.getWidth() / 2.0f;
            float halfH = (float)this.arrow.getHeight() / 2.0f;
            sb.draw(this.arrow, (float)this.x - 10.0f * Settings.xScale - halfW + halfW * 0.5f * Settings.scale, (float)this.y + 10.0f * Settings.yScale - halfH + halfH * 0.5f * Settings.scale, halfW, halfH, (float)this.arrow.getWidth(), (float)this.arrow.getHeight(), 0.75f * Settings.scale, 0.75f * Settings.scale, 0.0f, 0, 0, this.arrow.getWidth(), this.arrow.getHeight(), true, false);
            this.hitbox.render(sb);
        }

        @Override
        public void update() {
            this.hitbox.update();
            if (this.hitbox.hovered && InputHelper.justClickedLeft) {
                CardCrawlGame.sound.play("UI_CLICK_1");
                CustomCharacterSelectScreen.this.setCurrentOptions(true);
            }
        }

        @Override
        public int renderLayer() {
            return 0;
        }

        @Override
        public int updateOrder() {
            return 0;
        }
    }

    private class LeftOptionsButton
    implements IUIElement {
        private Texture arrow;
        private int x;
        private int y;
        private int w;
        private int h;
        private Hitbox hitbox;

        public LeftOptionsButton(String imgUrl, int x, int y) {
            this.arrow = ImageMaster.loadImage((String)imgUrl);
            this.x = x;
            this.y = y;
            this.w = (int)(Settings.scale * (float)this.arrow.getWidth() / 2.0f);
            this.h = (int)(Settings.scale * (float)this.arrow.getHeight() / 2.0f);
            this.hitbox = new Hitbox((float)x, (float)y, (float)this.w, (float)this.h);
        }

        public void move(float newX, float newY) {
            this.x = (int)(newX - (float)this.w / 2.0f);
            this.y = (int)(newY - (float)this.h / 2.0f);
            this.hitbox.move(newX, newY);
        }

        @Override
        public void render(SpriteBatch sb) {
            if (this.hitbox.hovered) {
                sb.setColor(Color.WHITE);
            } else {
                sb.setColor(Color.LIGHT_GRAY);
            }
            float halfW = (float)this.arrow.getWidth() / 2.0f;
            float halfH = (float)this.arrow.getHeight() / 2.0f;
            sb.draw(this.arrow, (float)this.x + 10.0f * Settings.xScale - halfW + halfW * 0.5f * Settings.scale, (float)this.y + 10.0f * Settings.yScale - halfH + halfH * 0.5f * Settings.scale, halfW, halfH, (float)this.arrow.getWidth(), (float)this.arrow.getHeight(), 0.75f * Settings.scale, 0.75f * Settings.scale, 0.0f, 0, 0, this.arrow.getWidth(), this.arrow.getHeight(), false, false);
            this.hitbox.render(sb);
        }

        @Override
        public void update() {
            this.hitbox.update();
            if (this.hitbox.hovered && InputHelper.justClickedLeft) {
                CardCrawlGame.sound.play("UI_CLICK_1");
                CustomCharacterSelectScreen.this.setCurrentOptions(false);
            }
        }

        @Override
        public int renderLayer() {
            return 0;
        }

        @Override
        public int updateOrder() {
            return 0;
        }
    }
}

