/*
 * Decompiled with CFR 0.152.
 */
package basemod;

import basemod.AutoComplete;
import basemod.BaseModInit;
import basemod.DevConsole;
import basemod.ModBadge;
import basemod.ModPanel;
import basemod.Pair;
import basemod.ReflectionHacks;
import basemod.TopPanelItem;
import basemod.abstracts.CustomBottleRelic;
import basemod.abstracts.CustomCard;
import basemod.abstracts.CustomReward;
import basemod.abstracts.CustomSavableRaw;
import basemod.abstracts.CustomUnlockBundle;
import basemod.abstracts.DynamicVariable;
import basemod.eventUtil.AddEventParams;
import basemod.eventUtil.EventUtils;
import basemod.helpers.RelicType;
import basemod.helpers.dynamicvariables.BlockVariable;
import basemod.helpers.dynamicvariables.DamageVariable;
import basemod.helpers.dynamicvariables.MagicNumberVariable;
import basemod.interfaces.AddAudioSubscriber;
import basemod.interfaces.AddCustomModeModsSubscriber;
import basemod.interfaces.CloneablePowerInterface;
import basemod.interfaces.EditCardsSubscriber;
import basemod.interfaces.EditCharactersSubscriber;
import basemod.interfaces.EditKeywordsSubscriber;
import basemod.interfaces.EditRelicsSubscriber;
import basemod.interfaces.EditStringsSubscriber;
import basemod.interfaces.ISubscriber;
import basemod.interfaces.MaxHPChangeSubscriber;
import basemod.interfaces.ModelRenderSubscriber;
import basemod.interfaces.OnCardUseSubscriber;
import basemod.interfaces.OnCreateDescriptionSubscriber;
import basemod.interfaces.OnPlayerDamagedSubscriber;
import basemod.interfaces.OnPlayerLoseBlockSubscriber;
import basemod.interfaces.OnPowersModifiedSubscriber;
import basemod.interfaces.OnStartBattleSubscriber;
import basemod.interfaces.PostBattleSubscriber;
import basemod.interfaces.PostCampfireSubscriber;
import basemod.interfaces.PostCreateShopPotionSubscriber;
import basemod.interfaces.PostCreateShopRelicSubscriber;
import basemod.interfaces.PostCreateStartingDeckSubscriber;
import basemod.interfaces.PostCreateStartingRelicsSubscriber;
import basemod.interfaces.PostDeathSubscriber;
import basemod.interfaces.PostDrawSubscriber;
import basemod.interfaces.PostDungeonInitializeSubscriber;
import basemod.interfaces.PostDungeonUpdateSubscriber;
import basemod.interfaces.PostEnergyRechargeSubscriber;
import basemod.interfaces.PostExhaustSubscriber;
import basemod.interfaces.PostInitializeSubscriber;
import basemod.interfaces.PostPlayerUpdateSubscriber;
import basemod.interfaces.PostPotionUseSubscriber;
import basemod.interfaces.PostPowerApplySubscriber;
import basemod.interfaces.PostRenderSubscriber;
import basemod.interfaces.PostUpdateSubscriber;
import basemod.interfaces.PotionGetSubscriber;
import basemod.interfaces.PreDungeonUpdateSubscriber;
import basemod.interfaces.PreMonsterTurnSubscriber;
import basemod.interfaces.PrePlayerUpdateSubscriber;
import basemod.interfaces.PrePotionUseSubscriber;
import basemod.interfaces.PreRenderSubscriber;
import basemod.interfaces.PreRoomRenderSubscriber;
import basemod.interfaces.PreStartGameSubscriber;
import basemod.interfaces.PreUpdateSubscriber;
import basemod.interfaces.RelicGetSubscriber;
import basemod.interfaces.RenderSubscriber;
import basemod.interfaces.SetUnlocksSubscriber;
import basemod.interfaces.StartActSubscriber;
import basemod.interfaces.StartGameSubscriber;
import basemod.patches.com.megacrit.cardcrawl.helpers.TopPanel.TopPanelHelper;
import basemod.patches.com.megacrit.cardcrawl.screens.select.GridCardSelectScreen.GridCardSelectScreenFields;
import basemod.patches.com.megacrit.cardcrawl.unlock.UnlockTracker.CountModdedUnlockCards;
import basemod.patches.whatmod.WhatMod;
import basemod.screens.ModalChoiceScreen;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.evacipated.cardcrawl.modthespire.Loader;
import com.evacipated.cardcrawl.modthespire.ModInfo;
import com.evacipated.cardcrawl.modthespire.lib.SpireConfig;
import com.evacipated.cardcrawl.modthespire.lib.SpireField;
import com.evacipated.cardcrawl.modthespire.lib.SpireInitializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.;
import com.megacrit.cardcrawl.audio.Sfx;
import com.megacrit.cardcrawl.audio.SoundMaster;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardGroup;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.helpers.CardLibrary;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.GameDictionary;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.MonsterHelper;
import com.megacrit.cardcrawl.helpers.RelicLibrary;
import com.megacrit.cardcrawl.helpers.TipHelper;
import com.megacrit.cardcrawl.integrations.steam.SteamIntegration;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.localization.LocalizedStrings;
import com.megacrit.cardcrawl.localization.RelicStrings;
import com.megacrit.cardcrawl.localization.RunModStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.monsters.MonsterGroup;
import com.megacrit.cardcrawl.monsters.MonsterInfo;
import com.megacrit.cardcrawl.potions.AbstractPotion;
import com.megacrit.cardcrawl.powers.AbstractPower;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.relics.Circlet;
import com.megacrit.cardcrawl.rewards.RewardItem;
import com.megacrit.cardcrawl.rewards.RewardSave;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import com.megacrit.cardcrawl.screens.charSelect.CharacterOption;
import com.megacrit.cardcrawl.screens.custom.CustomMod;
import com.megacrit.cardcrawl.screens.custom.CustomModeCharacterButton;
import com.megacrit.cardcrawl.shop.ShopScreen;
import com.megacrit.cardcrawl.shop.StorePotion;
import com.megacrit.cardcrawl.shop.StoreRelic;
import com.megacrit.cardcrawl.unlock.AbstractUnlock;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.clapper.util.classutil.AbstractClassFilter;
import org.clapper.util.classutil.AndClassFilter;
import org.clapper.util.classutil.ClassFilter;
import org.clapper.util.classutil.ClassFinder;
import org.clapper.util.classutil.ClassInfo;
import org.clapper.util.classutil.FieldInfo;
import org.clapper.util.classutil.InterfaceOnlyClassFilter;
import org.clapper.util.classutil.NotClassFilter;
import org.clapper.util.classutil.RegexClassFilter;

@SpireInitializer
public class BaseMod {
    public static final Logger logger = LogManager.getLogger((String)BaseMod.class.getName());
    private static final int BADGES_PER_ROW = 16;
    private static final float BADGES_X = 640.0f;
    private static final float BADGES_Y = 250.0f;
    public static final float BADGE_W = 40.0f;
    public static final float BADGE_H = 40.0f;
    public static final int DEFAULT_MAX_HAND_SIZE = 10;
    public static int MAX_HAND_SIZE = 10;
    private static HashMap<Type, String> typeMaps;
    private static HashMap<Type, Type> typeTokens;
    private static ArrayList<ModBadge> modBadges;
    private static ArrayList<ISubscriber> toRemove;
    private static ArrayList<StartActSubscriber> startActSubscribers;
    private static ArrayList<PostCampfireSubscriber> postCampfireSubscribers;
    private static ArrayList<PostDrawSubscriber> postDrawSubscribers;
    private static ArrayList<PostExhaustSubscriber> postExhaustSubscribers;
    private static ArrayList<OnCardUseSubscriber> onCardUseSubscribers;
    private static ArrayList<PostDungeonInitializeSubscriber> postDungeonInitializeSubscribers;
    private static ArrayList<PostEnergyRechargeSubscriber> postEnergyRechargeSubscribers;
    private static ArrayList<PostInitializeSubscriber> postInitializeSubscribers;
    private static ArrayList<PreMonsterTurnSubscriber> preMonsterTurnSubscribers;
    private static ArrayList<RenderSubscriber> renderSubscribers;
    private static ArrayList<PreRenderSubscriber> preRenderSubscribers;
    private static ArrayList<PostRenderSubscriber> postRenderSubscribers;
    private static ArrayList<ModelRenderSubscriber> modelRenderSubscribers;
    private static ArrayList<PreStartGameSubscriber> preStartGameSubscribers;
    private static ArrayList<StartGameSubscriber> startGameSubscribers;
    private static ArrayList<PreUpdateSubscriber> preUpdateSubscribers;
    private static ArrayList<PostUpdateSubscriber> postUpdateSubscribers;
    private static ArrayList<PostDungeonUpdateSubscriber> postDungeonUpdateSubscribers;
    private static ArrayList<PreDungeonUpdateSubscriber> preDungeonUpdateSubscribers;
    private static ArrayList<PostPlayerUpdateSubscriber> postPlayerUpdateSubscribers;
    private static ArrayList<PrePlayerUpdateSubscriber> prePlayerUpdateSubscribers;
    private static ArrayList<PostCreateStartingDeckSubscriber> postCreateStartingDeckSubscribers;
    private static ArrayList<PostCreateStartingRelicsSubscriber> postCreateStartingRelicsSubscribers;
    private static ArrayList<PostCreateShopRelicSubscriber> postCreateShopRelicSubscribers;
    private static ArrayList<PostCreateShopPotionSubscriber> postCreateShopPotionSubscribers;
    private static ArrayList<EditCardsSubscriber> editCardsSubscribers;
    private static ArrayList<EditRelicsSubscriber> editRelicsSubscribers;
    private static ArrayList<EditCharactersSubscriber> editCharactersSubscribers;
    private static ArrayList<EditStringsSubscriber> editStringsSubscribers;
    private static ArrayList<AddAudioSubscriber> addAudioSubscribers;
    private static ArrayList<EditKeywordsSubscriber> editKeywordsSubscribers;
    private static ArrayList<PostBattleSubscriber> postBattleSubscribers;
    private static ArrayList<SetUnlocksSubscriber> setUnlocksSubscribers;
    private static ArrayList<PostPotionUseSubscriber> postPotionUseSubscribers;
    private static ArrayList<PrePotionUseSubscriber> prePotionUseSubscribers;
    private static ArrayList<PotionGetSubscriber> potionGetSubscribers;
    private static ArrayList<RelicGetSubscriber> relicGetSubscribers;
    private static ArrayList<PostPowerApplySubscriber> postPowerApplySubscribers;
    private static ArrayList<OnPowersModifiedSubscriber> onPowersModifiedSubscribers;
    private static ArrayList<PostDeathSubscriber> postDeathSubscribers;
    private static ArrayList<OnStartBattleSubscriber> startBattleSubscribers;
    private static ArrayList<AddCustomModeModsSubscriber> addCustomModeModsSubscribers;
    private static ArrayList<MaxHPChangeSubscriber> maxHPChangeSubscribers;
    private static ArrayList<PreRoomRenderSubscriber> preRoomRenderSubscribers;
    private static ArrayList<OnPlayerLoseBlockSubscriber> onPlayerLoseBlockSubscribers;
    private static ArrayList<OnPlayerDamagedSubscriber> onPlayerDamagedSubscribers;
    private static ArrayList<OnCreateDescriptionSubscriber> onCreateDescriptionSubscribers;
    private static ArrayList<AbstractCard> redToAdd;
    private static ArrayList<String> redToRemove;
    private static ArrayList<AbstractCard> greenToAdd;
    private static ArrayList<String> greenToRemove;
    private static ArrayList<AbstractCard> blueToAdd;
    private static ArrayList<String> blueToRemove;
    private static ArrayList<AbstractCard> purpleToAdd;
    private static ArrayList<String> purpleToRemove;
    private static ArrayList<AbstractCard> colorlessToAdd;
    private static ArrayList<String> colorlessToRemove;
    private static ArrayList<AbstractCard> curseToAdd;
    private static ArrayList<String> curseToRemove;
    private static ArrayList<AbstractCard> customToAdd;
    private static ArrayList<String> customToRemove;
    private static ArrayList<AbstractCard.CardColor> customToRemoveColors;
    private static HashMap<AbstractCard.CardColor, HashMap<String, AbstractRelic>> customRelicPools;
    private static HashMap<AbstractCard.CardColor, ArrayList<AbstractRelic>> customRelicLists;
    private static HashMap<String, Pair<Predicate<AbstractCard>, AbstractRelic>> customBottleRelics;
    private static ArrayList<String> potionsToRemove;
    private static int lastBaseCharacterIndex;
    public static HashMap<AbstractPlayer.PlayerClass, String> playerSelectButtonMap;
    public static HashMap<AbstractPlayer.PlayerClass, String> customModeCharacterButtonMap;
    public static HashMap<AbstractPlayer.PlayerClass, String> playerPortraitMap;
    public static HashMap<String, DynamicVariable> cardDynamicVariableMap;
    private static HashMap<String, Class<? extends AbstractPotion>> potionClassMap;
    private static HashMap<String, Color> potionHybridColorMap;
    private static HashMap<String, Color> potionLiquidColorMap;
    private static HashMap<String, Color> potionSpotsColorMap;
    private static HashMap<String, AbstractPlayer.PlayerClass> potionPlayerClassMap;
    private static HashMap<String, Class<? extends AbstractPower>> powerMap;
    private static HashMap<String, Sfx> audioToAdd;
    private static HashMap<String, String> keywordProperNames;
    private static HashMap<String, String> keywordUniqueNames;
    private static HashMap<String, String> keywordUniquePrefixes;
    public static ArrayList<String> encounterList;
    public static HashMap<String, String> underScoreEncounterIDs;
    public static HashMap<String, String> underScoreCardIDs;
    public static HashMap<String, String> underScorePotionIDs;
    public static HashMap<String, String> underScorePowerIDs;
    public static HashMap<String, String> underScoreEventIDs;
    public static HashMap<String, String> underScoreRelicIDs;
    private static HashMap<AbstractCard.CardColor, Color> colorBgColorMap;
    private static HashMap<AbstractCard.CardColor, Color> colorBackColorMap;
    private static HashMap<AbstractCard.CardColor, Color> colorFrameColorMap;
    private static HashMap<AbstractCard.CardColor, Color> colorFrameOutlineColorMap;
    private static HashMap<AbstractCard.CardColor, Color> colorDescBoxColorMap;
    private static HashMap<AbstractCard.CardColor, Color> colorTrailVfxMap;
    private static HashMap<AbstractCard.CardColor, Color> colorGlowColorMap;
    private static HashMap<AbstractCard.CardColor, Integer> colorCardCountMap;
    private static HashMap<AbstractCard.CardColor, Integer> colorCardSeenCountMap;
    private static HashMap<AbstractCard.CardColor, String> colorAttackBgMap;
    private static HashMap<AbstractCard.CardColor, String> colorSkillBgMap;
    private static HashMap<AbstractCard.CardColor, String> colorPowerBgMap;
    private static HashMap<AbstractCard.CardColor, String> colorEnergyOrbMap;
    private static HashMap<AbstractCard.CardColor, String> colorCardEnergyOrbMap;
    private static HashMap<AbstractCard.CardColor, String> colorAttackBgPortraitMap;
    private static HashMap<AbstractCard.CardColor, String> colorSkillBgPortraitMap;
    private static HashMap<AbstractCard.CardColor, String> colorPowerBgPortraitMap;
    private static HashMap<AbstractCard.CardColor, String> colorEnergyOrbPortraitMap;
    private static HashMap<AbstractCard.CardColor, Texture> colorAttackBgTextureMap;
    private static HashMap<AbstractCard.CardColor, Texture> colorSkillBgTextureMap;
    private static HashMap<AbstractCard.CardColor, Texture> colorPowerBgTextureMap;
    private static HashMap<AbstractCard.CardColor, Texture> colorEnergyOrbTextureMap;
    private static HashMap<AbstractCard.CardColor, Texture> colorAttackBgPortraitTextureMap;
    private static HashMap<AbstractCard.CardColor, Texture> colorSkillBgPortraitTextureMap;
    private static HashMap<AbstractCard.CardColor, Texture> colorPowerBgPortraitTextureMap;
    private static HashMap<AbstractCard.CardColor, Texture> colorEnergyOrbPortraitTextureMap;
    private static HashMap<AbstractCard.CardColor, TextureAtlas.AtlasRegion> colorCardEnergyOrbAtlasRegionMap;
    private static HashMap<AbstractPlayer.PlayerClass, HashMap<Integer, CustomUnlockBundle>> unlockBundles;
    private static HashMap<AbstractPlayer.PlayerClass, ArrayList<String>> unlockCards;
    private static HashMap<AbstractPlayer.PlayerClass, Integer> maxUnlockLevel;
    private static HashMap<String, CustomSavableRaw> customSaveFields;
    private static OrthographicCamera animationCamera;
    private static ModelBatch batch;
    private static Environment animationEnvironment;
    private static FrameBuffer animationBuffer;
    private static Texture animationTexture;
    private static TextureRegion animationTextureRegion;
    public static final String CONFIG_FILE = "basemod-config";
    private static SpireConfig config;
    public static final String save_path;
    public static DevConsole console;
    public static Gson gson;
    public static boolean modSettingsUp;
    public static float mapPathDensityMultiplier;
    public static ModalChoiceScreen modalChoiceScreen;
    private static HashMap<RewardItem.RewardType, LoadCustomReward> customRewardOnLoadConsumers;
    private static HashMap<RewardItem.RewardType, SaveCustomReward> customRewardOnSaveConsumers;
    private static HashMap<String, String> customMonsterNames;
    private static HashMap<String, GetMonsterGroup> customMonsters;
    private static HashMap<String, List<MonsterInfo>> customMonsterEncounters;
    private static HashMap<String, List<MonsterInfo>> customStrongMonsterEncounters;
    private static HashMap<String, List<MonsterInfo>> customEliteEncounters;
    private static HashMap<String, List<BossInfo>> customBosses;

    private static SpireConfig makeConfig() {
        Properties defaultProperties = new Properties();
        defaultProperties.setProperty("console-key", "`");
        defaultProperties.setProperty("autocomplete-enabled", Boolean.toString(true));
        defaultProperties.setProperty("whatmod-enabled", Boolean.toString(true));
        try {
            SpireConfig retConfig = new SpireConfig("BaseMod", CONFIG_FILE, defaultProperties);
            return retConfig;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String getString(String key) {
        return config.getString(key);
    }

    static void setString(String key, String value) {
        config.setString(key, value);
        try {
            config.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Boolean getBoolean(String key) {
        return config.getBool(key);
    }

    static void setBoolean(String key, Boolean value) {
        config.setBool(key, value.booleanValue());
        try {
            config.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void setProperties() {
        Boolean whatmodEnabled;
        Boolean autoCompleteEnabled;
        Boolean consoleEnabled;
        if (config == null) {
            return;
        }
        String consoleKey = BaseMod.getString("console-key");
        if (consoleKey != null) {
            DevConsole.toggleKey = Input.Keys.valueOf((String)consoleKey);
        }
        if ((consoleEnabled = BaseMod.getBoolean("console-enabled")) != null) {
            DevConsole.enabled = consoleEnabled;
        }
        if ((autoCompleteEnabled = BaseMod.getBoolean("autocomplete-enabled")) != null) {
            AutoComplete.enabled = autoCompleteEnabled;
        }
        if ((whatmodEnabled = BaseMod.getBoolean("whatmod-enabled")) != null) {
            WhatMod.enabled = whatmodEnabled;
        }
    }

    public static boolean isBaseGameCharacter(AbstractPlayer c) {
        return BaseMod.isBaseGameCharacter(c.chosenClass);
    }

    public static boolean isBaseGameCharacter(AbstractPlayer.PlayerClass chosenClass) {
        int index = -1;
        for (AbstractPlayer player : CardCrawlGame.characterManager.getAllCharacters()) {
            ++index;
            if (player.chosenClass != chosenClass) continue;
            break;
        }
        return index <= lastBaseCharacterIndex;
    }

    public static boolean isBaseGameCardColor(AbstractCard.CardColor color) {
        return color.compareTo((Enum)AbstractCard.CardColor.CURSE) <= 0;
    }

    public static void initialize() {
        System.out.println("libgdx version 1.9.5");
        modBadges = new ArrayList();
        BaseMod.initializeGson();
        BaseMod.initializeTypeMaps();
        BaseMod.initializeSubscriptions();
        BaseMod.initializeCardLists();
        BaseMod.initializeCharacterMap();
        BaseMod.initializeColorMap();
        BaseMod.initializeRelicPool();
        BaseMod.initializeUnlocks();
        BaseMod.initializePotionMap();
        BaseMod.initializePotionList();
        BaseMod.initializePowerMap();
        BaseMod.initializeUnderscorePowerIDs();
        audioToAdd = new HashMap();
        keywordProperNames = new HashMap();
        keywordUniqueNames = new HashMap();
        keywordUniquePrefixes = new HashMap();
        BaseModInit baseModInit = new BaseModInit();
        BaseMod.subscribe(baseModInit);
        config = BaseMod.makeConfig();
        BaseMod.setProperties();
        console = new DevConsole();
    }

    private static void setupAnimationGfx() {
        animationCamera = new OrthographicCamera((float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight());
        BaseMod.animationCamera.near = 1.0f;
        BaseMod.animationCamera.far = 300.0f;
        BaseMod.animationCamera.position.z = 200.0f;
        animationCamera.update();
        batch = new ModelBatch();
        animationEnvironment = new Environment();
        animationEnvironment.set((Attribute)new ColorAttribute(ColorAttribute.AmbientLight, 1.0f, 1.0f, 1.0f, 1.0f));
        animationBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), false);
    }

    private static void initializeGson() {
        logger.info("initializeGson");
        GsonBuilder gsonBuilder = new GsonBuilder();
        gson = gsonBuilder.create();
    }

    private static void initializeTypeMaps() {
        logger.info("initializeTypeMaps");
        typeMaps = new HashMap();
        typeTokens = new HashMap();
        for (Field f : LocalizedStrings.class.getDeclaredFields()) {
            ParameterizedType pType;
            Type[] typeArgs;
            Type type = f.getGenericType();
            if (!(type instanceof ParameterizedType) || (typeArgs = (pType = (ParameterizedType)type).getActualTypeArguments()).length != 2 || !typeArgs[0].equals(String.class) || !typeArgs[1].getTypeName().startsWith("com.megacrit.cardcrawl.localization.") || !typeArgs[1].getTypeName().endsWith("Strings")) continue;
            logger.info("Registered " + typeArgs[1].getTypeName().replace("com.megacrit.cardcrawl.localization.", ""));
            typeMaps.put(typeArgs[1], f.getName());
            ParameterizedType p = .Gson.Types.newParameterizedTypeWithOwner(null, Map.class, (Type[])new Type[]{String.class, typeArgs[1]});
            typeTokens.put(typeArgs[1], p);
        }
    }

    private static void initializeSubscriptions() {
        toRemove = new ArrayList();
        startActSubscribers = new ArrayList();
        postCampfireSubscribers = new ArrayList();
        postDrawSubscribers = new ArrayList();
        postExhaustSubscribers = new ArrayList();
        onCardUseSubscribers = new ArrayList();
        postDungeonInitializeSubscribers = new ArrayList();
        postEnergyRechargeSubscribers = new ArrayList();
        postInitializeSubscribers = new ArrayList();
        preMonsterTurnSubscribers = new ArrayList();
        renderSubscribers = new ArrayList();
        preRenderSubscribers = new ArrayList();
        postRenderSubscribers = new ArrayList();
        modelRenderSubscribers = new ArrayList();
        preStartGameSubscribers = new ArrayList();
        startGameSubscribers = new ArrayList();
        preUpdateSubscribers = new ArrayList();
        postUpdateSubscribers = new ArrayList();
        postDungeonUpdateSubscribers = new ArrayList();
        preDungeonUpdateSubscribers = new ArrayList();
        postPlayerUpdateSubscribers = new ArrayList();
        prePlayerUpdateSubscribers = new ArrayList();
        postCreateStartingDeckSubscribers = new ArrayList();
        postCreateStartingRelicsSubscribers = new ArrayList();
        postCreateShopRelicSubscribers = new ArrayList();
        postCreateShopPotionSubscribers = new ArrayList();
        editCardsSubscribers = new ArrayList();
        editRelicsSubscribers = new ArrayList();
        editCharactersSubscribers = new ArrayList();
        editStringsSubscribers = new ArrayList();
        addAudioSubscribers = new ArrayList();
        editKeywordsSubscribers = new ArrayList();
        postBattleSubscribers = new ArrayList();
        setUnlocksSubscribers = new ArrayList();
        postPotionUseSubscribers = new ArrayList();
        prePotionUseSubscribers = new ArrayList();
        potionGetSubscribers = new ArrayList();
        relicGetSubscribers = new ArrayList();
        postPowerApplySubscribers = new ArrayList();
        onPowersModifiedSubscribers = new ArrayList();
        postDeathSubscribers = new ArrayList();
        startBattleSubscribers = new ArrayList();
        addCustomModeModsSubscribers = new ArrayList();
        maxHPChangeSubscribers = new ArrayList();
        preRoomRenderSubscribers = new ArrayList();
        onPlayerLoseBlockSubscribers = new ArrayList();
        onPlayerDamagedSubscribers = new ArrayList();
        onCreateDescriptionSubscribers = new ArrayList();
    }

    private static void initializeCardLists() {
        redToAdd = new ArrayList();
        redToRemove = new ArrayList();
        greenToAdd = new ArrayList();
        greenToRemove = new ArrayList();
        blueToAdd = new ArrayList();
        blueToRemove = new ArrayList();
        purpleToAdd = new ArrayList();
        purpleToRemove = new ArrayList();
        colorlessToAdd = new ArrayList();
        colorlessToRemove = new ArrayList();
        curseToAdd = new ArrayList();
        curseToRemove = new ArrayList();
        customToAdd = new ArrayList();
        customToRemove = new ArrayList();
        customToRemoveColors = new ArrayList();
    }

    private static void initializeCharacterMap() {
        playerSelectButtonMap = new HashMap();
        customModeCharacterButtonMap = new HashMap();
        playerPortraitMap = new HashMap();
    }

    private static void initializeColorMap() {
        colorBgColorMap = new HashMap();
        colorBackColorMap = new HashMap();
        colorFrameColorMap = new HashMap();
        colorFrameOutlineColorMap = new HashMap();
        colorDescBoxColorMap = new HashMap();
        colorTrailVfxMap = new HashMap();
        colorGlowColorMap = new HashMap();
        colorCardCountMap = new HashMap();
        colorCardSeenCountMap = new HashMap();
        colorAttackBgMap = new HashMap();
        colorSkillBgMap = new HashMap();
        colorPowerBgMap = new HashMap();
        colorEnergyOrbMap = new HashMap();
        colorCardEnergyOrbMap = new HashMap();
        colorAttackBgPortraitMap = new HashMap();
        colorSkillBgPortraitMap = new HashMap();
        colorPowerBgPortraitMap = new HashMap();
        colorEnergyOrbPortraitMap = new HashMap();
        colorAttackBgTextureMap = new HashMap();
        colorSkillBgTextureMap = new HashMap();
        colorPowerBgTextureMap = new HashMap();
        colorEnergyOrbTextureMap = new HashMap();
        colorAttackBgPortraitTextureMap = new HashMap();
        colorSkillBgPortraitTextureMap = new HashMap();
        colorPowerBgPortraitTextureMap = new HashMap();
        colorEnergyOrbPortraitTextureMap = new HashMap();
        colorCardEnergyOrbAtlasRegionMap = new HashMap();
    }

    private static void initializeRelicPool() {
        customRelicPools = new HashMap();
        customRelicLists = new HashMap();
        customBottleRelics = new HashMap();
    }

    private static void initializeUnlocks() {
        unlockBundles = new HashMap();
        unlockCards = new HashMap();
        maxUnlockLevel = new HashMap();
    }

    private static void initializePotionMap() {
        potionClassMap = new HashMap();
        potionHybridColorMap = new HashMap();
        potionLiquidColorMap = new HashMap();
        potionSpotsColorMap = new HashMap();
        potionPlayerClassMap = new HashMap();
    }

    private static void initializePotionList() {
        potionsToRemove = new ArrayList();
    }

    public static void initializeUnderscorePotionIDs() {
        logger.info("initializeUnderscorePotionIDs");
        underScorePotionIDs = new HashMap();
        Map potions = (Map)ReflectionHacks.getPrivateStatic(LocalizedStrings.class, "potions");
        if (potions != null) {
            for (String key : potions.keySet()) {
                if (!key.contains(" ")) continue;
                underScorePotionIDs.put(key.replace(' ', '_'), key);
            }
        }
    }

    public static void initializeUnderscoreEventIDs() {
        logger.info("initializeUnderscoreEventIDs");
        underScoreEventIDs = new HashMap();
        Map events = (Map)ReflectionHacks.getPrivateStatic(LocalizedStrings.class, "events");
        if (events != null) {
            for (String key : events.keySet()) {
                if (!key.contains(" ")) continue;
                underScoreEventIDs.put(key.replace(' ', '_'), key);
            }
        }
    }

    private static void addAudioToSoundMaster(SoundMaster __instance) {
        HashMap map = (HashMap)ReflectionHacks.getPrivate(__instance, SoundMaster.class, "map");
        if (map != null) {
            map.putAll(audioToAdd);
            logger.info("Added " + audioToAdd.size() + " sounds");
            audioToAdd.clear();
        } else {
            logger.warn("Unexpectedly failed to add sounds.");
        }
        ReflectionHacks.setPrivate(__instance, SoundMaster.class, "map", map);
    }

    static void initializeEncounters() {
        logger.info("initializeEncounters");
        encounterList = new ArrayList();
        try {
            Field[] fields;
            for (Field f : fields = MonsterHelper.class.getDeclaredFields()) {
                int mods;
                if (f.getType() != String.class || !Modifier.isStatic(mods = f.getModifiers()) || !Modifier.isPublic(mods) || !Modifier.isFinal(mods)) continue;
                encounterList.add((String)f.get(null));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        underScoreEncounterIDs = new HashMap();
        for (String id : encounterList) {
            if (!id.contains(" ")) continue;
            underScoreEncounterIDs.put(id.replace(' ', '_'), id);
        }
    }

    public static void initializeUnderscoreCardIDs() {
        logger.info("initializeUnderscoreCardIDs");
        underScoreCardIDs = new HashMap();
        for (String key : CardLibrary.cards.keySet()) {
            if (!key.contains(" ")) continue;
            underScoreCardIDs.put(key.replace(' ', '_'), key);
        }
    }

    public static void initializeUnderscoreRelicIDs() {
        logger.info("initializeUnderscoreRelicIDs");
        underScoreRelicIDs = new HashMap();
        for (String id : BaseMod.listAllRelicIDs()) {
            if (!id.contains(" ")) continue;
            underScoreRelicIDs.put(id.replace(' ', '_'), id);
        }
    }

    private static void initializePowerMap() {
        logger.info("initializePowerMap");
        powerMap = new HashMap();
        ClassFinder finder = new ClassFinder();
        try {
            ClassPool pool = Loader.getClassPool();
            CtClass ctCls = pool.get(AbstractPower.class.getName());
            String url = ctCls.getURL().getFile();
            int i = url.lastIndexOf(33);
            if (i >= 0) {
                url = url.substring(0, i);
            }
            if (url.endsWith(".jar")) {
                URL locationURL = new URL(url);
                finder.add(new File(locationURL.toURI()));
            }
            AndClassFilter filter = new AndClassFilter(new ClassFilter[]{new NotClassFilter((ClassFilter)new InterfaceOnlyClassFilter()), new NotClassFilter((ClassFilter)new AbstractClassFilter()), new RegexClassFilter("com\\.megacrit\\.cardcrawl\\.powers\\..+")});
            ArrayList foundClasses = new ArrayList();
            finder.findClasses(foundClasses, (ClassFilter)filter);
            for (ClassInfo classInfo : foundClasses) {
                if (classInfo.getClassName().contains("$")) continue;
                try {
                    if (!CloneablePowerInterface.class.isAssignableFrom(BaseMod.class.getClassLoader().loadClass(classInfo.getClassName()))) {
                        logger.warn(String.format("Power (%s) isn't Cloneable", classInfo.getClassName()));
                    }
                    for (FieldInfo fieldInfo : classInfo.getFields()) {
                        if (!fieldInfo.getName().equals("POWER_ID") || !(fieldInfo.getValue() instanceof String)) continue;
                        powerMap.put((String)fieldInfo.getValue(), BaseMod.class.getClassLoader().loadClass(classInfo.getClassName()));
                    }
                }
                catch (ClassNotFoundException e) {
                    System.out.println("ERROR: Failed to load power class: " + classInfo.getClassName());
                }
            }
        }
        catch (MalformedURLException | URISyntaxException | NotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void initializeUnderscorePowerIDs() {
        logger.info("initializeUnderscorePowerIDs");
        underScorePowerIDs = new HashMap();
        for (String key : powerMap.keySet()) {
            if (!key.contains(" ")) continue;
            underScorePowerIDs.put(key.replace(' ', '_'), key);
        }
    }

    public static void registerModBadge(Texture t, String name, String author, String desc, ModPanel settingsPanel) {
        logger.info("registerModBadge : " + name);
        int modBadgeCount = modBadges.size();
        int col = modBadgeCount % 16;
        int row = modBadgeCount / 16;
        float x = 640.0f * Settings.scale + (float)col * 40.0f * Settings.scale;
        float y = 250.0f * Settings.scale - (float)row * 40.0f * Settings.scale;
        ModBadge badge = new ModBadge(t, x, y, name, author, desc, settingsPanel);
        modBadges.add(badge);
    }

    public static String colorString(String input, String colorValue) {
        StringBuilder retVal = new StringBuilder();
        Scanner s = new Scanner(input);
        while (s.hasNext()) {
            retVal.append("[").append(colorValue).append("]").append(s.next());
            retVal.append(" ");
        }
        s.close();
        return retVal.toString().trim();
    }

    private static void loadJsonStrings(Type stringType, String jsonString) {
        logger.info("loadJsonStrings: " + stringType.getTypeName());
        String typeMap = typeMaps.get(stringType);
        Type typeToken = typeTokens.get(stringType);
        String modName = BaseMod.findCallingModName();
        Map localizationStrings = (Map)ReflectionHacks.getPrivateStatic(LocalizedStrings.class, typeMap);
        HashMap map = new HashMap((Map)gson.fromJson(jsonString, typeToken));
        if (stringType.equals(CardStrings.class) || stringType.equals(RelicStrings.class)) {
            HashMap map2 = new HashMap();
            for (Object k : map.keySet()) {
                map2.put(modName == null ? k : modName + ":" + k, map.get(k));
            }
            localizationStrings.putAll(map2);
        } else {
            localizationStrings.putAll(map);
        }
        ReflectionHacks.setPrivateStaticFinal(LocalizedStrings.class, typeMap, localizationStrings);
    }

    public static void loadCustomStrings(Class<?> stringType, String jsonString) {
        BaseMod.loadJsonStrings(stringType, jsonString);
    }

    public static void loadCustomStringsFile(Class<?> stringType, String filepath) {
        BaseMod.loadJsonStrings(stringType, Gdx.files.internal(filepath).readString(String.valueOf(StandardCharsets.UTF_8)));
    }

    public static ArrayList<AbstractCard> getRedCardsToAdd() {
        return redToAdd;
    }

    public static ArrayList<String> getRedCardsToRemove() {
        return redToRemove;
    }

    public static ArrayList<AbstractCard> getGreenCardsToAdd() {
        return greenToAdd;
    }

    public static ArrayList<String> getGreenCardsToRemove() {
        return greenToRemove;
    }

    public static ArrayList<AbstractCard> getBlueCardsToAdd() {
        return blueToAdd;
    }

    public static ArrayList<String> getBlueCardsToRemove() {
        return blueToRemove;
    }

    public static ArrayList<AbstractCard> getPurpleCardsToAdd() {
        return purpleToAdd;
    }

    public static ArrayList<String> getPurpleCardsToRemove() {
        return purpleToRemove;
    }

    public static ArrayList<AbstractCard> getColorlessCardsToAdd() {
        return colorlessToAdd;
    }

    public static ArrayList<String> getColorlessCardsToRemove() {
        return colorlessToRemove;
    }

    public static ArrayList<AbstractCard> getCurseCardsToAdd() {
        return curseToAdd;
    }

    public static ArrayList<String> getCurseCardsToRemove() {
        return curseToRemove;
    }

    public static ArrayList<AbstractCard> getCustomCardsToAdd() {
        return customToAdd;
    }

    public static ArrayList<String> getCustomCardsToRemove() {
        return customToRemove;
    }

    public static ArrayList<AbstractCard.CardColor> getCustomCardsToRemoveColors() {
        return customToRemoveColors;
    }

    public static void addAudio(String audioKey, String file) {
        FileHandle sfxFile = Gdx.files.internal(file);
        if (sfxFile != null && sfxFile.exists()) {
            Sfx audioSfx = new Sfx(file, false);
            audioToAdd.put(audioKey, audioSfx);
        } else {
            logger.warn("Audio file: " + file + " was not found.");
        }
    }

    public static void addCard(AbstractCard card) {
        switch (card.color) {
            case RED: {
                redToAdd.add(card);
                break;
            }
            case GREEN: {
                greenToAdd.add(card);
                break;
            }
            case BLUE: {
                blueToAdd.add(card);
                break;
            }
            case PURPLE: {
                purpleToAdd.add(card);
                break;
            }
            case COLORLESS: {
                colorlessToAdd.add(card);
                break;
            }
            case CURSE: {
                curseToAdd.add(card);
                break;
            }
            default: {
                customToAdd.add(card);
            }
        }
    }

    public static void removeCard(String card, AbstractCard.CardColor color) {
        switch (color) {
            case RED: {
                redToRemove.add(card);
                break;
            }
            case GREEN: {
                greenToRemove.add(card);
                break;
            }
            case BLUE: {
                blueToRemove.add(card);
                break;
            }
            case PURPLE: {
                purpleToRemove.add(card);
            }
            case COLORLESS: {
                colorlessToRemove.add(card);
                break;
            }
            case CURSE: {
                curseToRemove.add(card);
                break;
            }
            default: {
                customToRemove.add(card);
                customToRemoveColors.add(color);
            }
        }
    }

    public static void addDynamicVariable(DynamicVariable dv) {
        cardDynamicVariableMap.put(dv.key(), dv);
    }

    public static float calculateCardDamage(AbstractPlayer player, AbstractMonster mo, AbstractCard c, float tmp) {
        if (c instanceof CustomCard) {
            float newVal = ((CustomCard)c).calculateModifiedCardDamage(player, mo, tmp);
            if ((int)newVal != c.baseDamage) {
                c.isDamageModified = true;
            }
            return newVal;
        }
        return tmp;
    }

    public static float calculateCardDamage(AbstractPlayer player, AbstractCard c, float tmp) {
        return BaseMod.calculateCardDamage(player, null, c, tmp);
    }

    public static void addRelic(AbstractRelic relic, RelicType type) {
        switch (type) {
            case SHARED: {
                RelicLibrary.add((AbstractRelic)relic);
                break;
            }
            case RED: {
                RelicLibrary.addRed((AbstractRelic)relic);
                break;
            }
            case GREEN: {
                RelicLibrary.addGreen((AbstractRelic)relic);
                break;
            }
            case BLUE: {
                RelicLibrary.addBlue((AbstractRelic)relic);
                break;
            }
            case PURPLE: {
                RelicLibrary.addPurple((AbstractRelic)relic);
                break;
            }
            default: {
                logger.info("tried to add relic of unsupported type: " + relic + " " + (Object)((Object)type));
                return;
            }
        }
        if (relic instanceof CustomBottleRelic) {
            BaseMod.registerBottleRelic(((CustomBottleRelic)relic).isOnCard(), relic);
        }
    }

    public static void removeRelic(AbstractRelic relic, RelicType type) {
        switch (type) {
            case SHARED: {
                HashMap sharedRelics = (HashMap)ReflectionHacks.getPrivateStatic(RelicLibrary.class, "sharedRelics");
                if (!sharedRelics.containsKey(relic.relicId)) break;
                sharedRelics.remove(relic.relicId);
                --RelicLibrary.totalRelicCount;
                BaseMod.removeRelicFromTierList(relic);
                break;
            }
            case RED: {
                HashMap redRelics = (HashMap)ReflectionHacks.getPrivateStatic(RelicLibrary.class, "redRelics");
                if (!redRelics.containsKey(relic.relicId)) break;
                redRelics.remove(relic.relicId);
                --RelicLibrary.totalRelicCount;
                BaseMod.removeRelicFromTierList(relic);
                break;
            }
            case GREEN: {
                HashMap greenRelics = (HashMap)ReflectionHacks.getPrivateStatic(RelicLibrary.class, "greenRelics");
                if (!greenRelics.containsKey(relic.relicId)) break;
                greenRelics.remove(relic.relicId);
                --RelicLibrary.totalRelicCount;
                BaseMod.removeRelicFromTierList(relic);
                break;
            }
            case BLUE: {
                HashMap blueRelics = (HashMap)ReflectionHacks.getPrivateStatic(RelicLibrary.class, "blueRelics");
                if (!blueRelics.containsKey(relic.relicId)) break;
                blueRelics.remove(relic.relicId);
                --RelicLibrary.totalRelicCount;
                BaseMod.removeRelicFromTierList(relic);
                break;
            }
            case PURPLE: {
                HashMap purpleRelics = (HashMap)ReflectionHacks.getPrivateStatic(RelicLibrary.class, "purpleRelics");
                if (!purpleRelics.containsKey(relic.relicId)) break;
                purpleRelics.remove(relic.relicId);
                --RelicLibrary.totalRelicCount;
                BaseMod.removeRelicFromTierList(relic);
                break;
            }
            default: {
                logger.info("tried to remove relic of unsupported type: " + relic + " " + (Object)((Object)type));
            }
        }
    }

    public static void removeRelicFromCustomPool(AbstractRelic relic, AbstractCard.CardColor color) {
        if (relic == null) {
            return;
        }
        if (customRelicPools.containsKey(color) && customRelicPools.get(color).containsKey(relic.relicId)) {
            customRelicPools.get(color).remove(relic.relicId);
            --RelicLibrary.totalRelicCount;
            BaseMod.removeRelicFromTierList(relic);
        }
        if (customRelicLists.containsKey(color) && customRelicLists.get(color).contains(relic)) {
            customRelicLists.get(color).remove(relic);
        }
    }

    public static void registerBottleRelic(Predicate<AbstractCard> isOnCard, AbstractRelic relic) {
        customBottleRelics.put(relic.relicId, new Pair<Predicate<AbstractCard>, AbstractRelic>(isOnCard, relic));
    }

    public static void registerBottleRelic(SpireField<Boolean> isOnCard, AbstractRelic relic) {
        customBottleRelics.put(relic.relicId, new Pair<Predicate<AbstractCard>, AbstractRelic>(arg_0 -> isOnCard.get(arg_0), relic));
    }

    public static void addRelicToCustomPool(AbstractRelic relic, AbstractCard.CardColor color) {
        if (customRelicPools.containsKey(color)) {
            if (UnlockTracker.isRelicSeen((String)relic.relicId)) {
                ++RelicLibrary.seenRelics;
            }
            relic.isSeen = UnlockTracker.isRelicSeen((String)relic.relicId);
            customRelicPools.get(color).put(relic.relicId, relic);
            RelicLibrary.addToTierList((AbstractRelic)relic);
            customRelicLists.get(color).add(relic);
            if (relic instanceof CustomBottleRelic) {
                BaseMod.registerBottleRelic(((CustomBottleRelic)relic).isOnCard(), relic);
            }
        } else {
            logger.error("could not add relic to non existent custom pool: " + color);
        }
    }

    public static HashMap<String, AbstractRelic> getRelicsInCustomPool(AbstractCard.CardColor color) {
        return customRelicPools.get(color);
    }

    public static HashMap<AbstractCard.CardColor, HashMap<String, AbstractRelic>> getAllCustomRelics() {
        return customRelicPools;
    }

    public static AbstractRelic getCustomRelic(String key) {
        for (HashMap<String, AbstractRelic> map : BaseMod.getAllCustomRelics().values()) {
            if (!map.containsKey(key)) continue;
            return map.get(key);
        }
        return new Circlet();
    }

    public static Collection<Pair<Predicate<AbstractCard>, AbstractRelic>> getBottledRelicList() {
        return customBottleRelics.values();
    }

    private static void removeRelicFromTierList(AbstractRelic relic) {
        switch (relic.tier) {
            case STARTER: {
                RelicLibrary.starterList.remove(relic);
                break;
            }
            case COMMON: {
                RelicLibrary.commonList.remove(relic);
                break;
            }
            case UNCOMMON: {
                RelicLibrary.uncommonList.remove(relic);
                break;
            }
            case RARE: {
                RelicLibrary.rareList.remove(relic);
                break;
            }
            case SHOP: {
                RelicLibrary.shopList.remove(relic);
                break;
            }
            case SPECIAL: {
                RelicLibrary.specialList.remove(relic);
                break;
            }
            case BOSS: {
                RelicLibrary.bossList.remove(relic);
                break;
            }
            case DEPRECATED: {
                logger.info(relic.relicId + " is deprecated.");
                break;
            }
            default: {
                logger.info(relic.relicId + "is undefined tier.");
            }
        }
    }

    public static void removeRelic(AbstractRelic relic) {
        BaseMod.removeRelic(relic, RelicType.SHARED);
        BaseMod.removeRelic(relic, RelicType.RED);
        BaseMod.removeRelic(relic, RelicType.GREEN);
        BaseMod.removeRelic(relic, RelicType.BLUE);
        BaseMod.removeRelic(relic, RelicType.PURPLE);
    }

    public static ArrayList<String> listAllRelicIDs() {
        HashMap purpleRelics;
        HashMap blueRelics;
        HashMap greenRelics;
        HashMap redRelics;
        HashSet<Object> relicIDs = new HashSet<Object>();
        HashMap sharedRelics = (HashMap)ReflectionHacks.getPrivateStatic(RelicLibrary.class, "sharedRelics");
        if (sharedRelics != null) {
            relicIDs.addAll(sharedRelics.keySet());
        }
        if ((redRelics = (HashMap)ReflectionHacks.getPrivateStatic(RelicLibrary.class, "redRelics")) != null) {
            relicIDs.addAll(redRelics.keySet());
        }
        if ((greenRelics = (HashMap)ReflectionHacks.getPrivateStatic(RelicLibrary.class, "greenRelics")) != null) {
            relicIDs.addAll(greenRelics.keySet());
        }
        if ((blueRelics = (HashMap)ReflectionHacks.getPrivateStatic(RelicLibrary.class, "blueRelics")) != null) {
            relicIDs.addAll(blueRelics.keySet());
        }
        if ((purpleRelics = (HashMap)ReflectionHacks.getPrivateStatic(RelicLibrary.class, "purpleRelics")) != null) {
            relicIDs.addAll(purpleRelics.keySet());
        }
        if (BaseMod.getAllCustomRelics() != null) {
            for (HashMap<String, AbstractRelic> e : BaseMod.getAllCustomRelics().values()) {
                if (e == null) continue;
                relicIDs.addAll(e.keySet());
            }
        }
        return new ArrayList<String>(relicIDs);
    }

    public static void registerCustomReward(RewardItem.RewardType type, LoadCustomReward onLoad, SaveCustomReward onSave) {
        customRewardOnLoadConsumers.put(type, onLoad);
        customRewardOnSaveConsumers.put(type, onSave);
    }

    public static CustomReward loadCustomRewardFromSave(RewardSave rewardSave) {
        return customRewardOnLoadConsumers.get(RewardItem.RewardType.valueOf((String)rewardSave.type)).onLoad(rewardSave);
    }

    public static RewardSave saveCustomReward(CustomReward reward) {
        return customRewardOnSaveConsumers.get(reward.type).onSave(reward);
    }

    public static boolean customRewardTypeExists(RewardItem.RewardType type) {
        return customRewardOnSaveConsumers.containsKey(type) && customRewardOnLoadConsumers.containsKey(type);
    }

    public static void addEvent(String eventID, Class<? extends AbstractEvent> eventClass) {
        BaseMod.addEvent(new AddEventParams.Builder(eventID, eventClass).create());
    }

    public static void addEvent(String eventID, Class<? extends AbstractEvent> eventClass, String dungeonID) {
        BaseMod.addEvent(new AddEventParams.Builder(eventID, eventClass).dungeonID(dungeonID).create());
    }

    public static void addEvent(AddEventParams params) {
        EventUtils.registerEvent(params.eventID, params.eventClass, params.playerClass, params.dungeonIDs.toArray(new String[0]), params.spawnCondition, params.overrideEventID, params.bonusCondition, params.eventType);
    }

    @Deprecated
    public static HashMap<String, Class<? extends AbstractEvent>> getEventList(String dungeonID) {
        return EventUtils.getDungeonEvents(dungeonID);
    }

    public static Class<? extends AbstractEvent> getEvent(String eventID) {
        return EventUtils.getEventClass(eventID);
    }

    public static void addTopPanelItem(TopPanelItem topPanelItem) {
        TopPanelHelper.topPanelGroup.addPanelItem(topPanelItem);
    }

    public static void removeTopPanelItem(TopPanelItem topPanelItem) {
        TopPanelHelper.topPanelGroup.removePanelItem(topPanelItem);
    }

    private static String autoCalculateMonsterName(GetMonsterGroup group) {
        StringBuilder ret = new StringBuilder();
        if (AbstractDungeon.monsterRng == null) {
            Settings.seed = 0L;
            AbstractDungeon.generateSeeds();
        }
        MonsterGroup monsters = group.get();
        boolean first = true;
        for (AbstractMonster monster : monsters.monsters) {
            if (!first) {
                ret.append(", ");
            }
            first = false;
            ret.append(monster.name);
        }
        return ret.toString();
    }

    public static void addMonster(String encounterID, GetMonster monster) {
        BaseMod.addMonster(encounterID, () -> new MonsterGroup(monster.get()));
    }

    public static void addMonster(String encounterID, String name, GetMonster monster) {
        BaseMod.addMonster(encounterID, name, () -> new MonsterGroup(monster.get()));
    }

    public static void addMonster(String encounterID, GetMonsterGroup group) {
        BaseMod.addMonster(encounterID, BaseMod.autoCalculateMonsterName(group), group);
    }

    public static void addMonster(String encounterID, String name, GetMonsterGroup group) {
        customMonsters.put(encounterID, group);
        customMonsterNames.put(encounterID, name);
        encounterList.add(encounterID);
        if (encounterID.contains(" ")) {
            underScoreEncounterIDs.put(encounterID.replace(' ', '_'), encounterID);
        }
    }

    public static MonsterGroup getMonster(String encounterID) {
        GetMonsterGroup getter = customMonsters.get(encounterID);
        if (getter == null) {
            return null;
        }
        return getter.get();
    }

    public static String getMonsterName(String encounterID) {
        return customMonsterNames.getOrDefault(encounterID, "");
    }

    public static boolean customMonsterExists(String encounterID) {
        return customMonsters.containsKey(encounterID);
    }

    public static void addEliteEncounter(String dungeonID, MonsterInfo encounter) {
        if (!customEliteEncounters.containsKey(dungeonID)) {
            customEliteEncounters.put(dungeonID, new ArrayList());
        }
        customEliteEncounters.get(dungeonID).add(encounter);
    }

    public static void addStrongMonsterEncounter(String dungeonID, MonsterInfo encounter) {
        if (!customStrongMonsterEncounters.containsKey(dungeonID)) {
            customStrongMonsterEncounters.put(dungeonID, new ArrayList());
        }
        customStrongMonsterEncounters.get(dungeonID).add(encounter);
    }

    public static void addMonsterEncounter(String dungeonID, MonsterInfo encounter) {
        if (!customMonsterEncounters.containsKey(dungeonID)) {
            customMonsterEncounters.put(dungeonID, new ArrayList());
        }
        customMonsterEncounters.get(dungeonID).add(encounter);
    }

    public static List<MonsterInfo> getEliteEncounters(String dungeonID) {
        if (customEliteEncounters.containsKey(dungeonID)) {
            return customEliteEncounters.get(dungeonID);
        }
        return new ArrayList<MonsterInfo>();
    }

    public static List<MonsterInfo> getStrongMonsterEncounters(String dungeonID) {
        if (customStrongMonsterEncounters.containsKey(dungeonID)) {
            return customStrongMonsterEncounters.get(dungeonID);
        }
        return new ArrayList<MonsterInfo>();
    }

    public static List<MonsterInfo> getMonsterEncounters(String dungeonID) {
        if (customMonsterEncounters.containsKey(dungeonID)) {
            return customMonsterEncounters.get(dungeonID);
        }
        return new ArrayList<MonsterInfo>();
    }

    public static void addBoss(String dungeon, String bossID, String mapIcon, String mapIconOutline) {
        if (!customBosses.containsKey(dungeon)) {
            customBosses.put(dungeon, new ArrayList());
        }
        BossInfo info = new BossInfo(bossID, mapIcon, mapIconOutline);
        customBosses.get(dungeon).add(info);
    }

    public static List<String> getBossIDs(String dungeonID) {
        if (customBosses.containsKey(dungeonID)) {
            return customBosses.get(dungeonID).stream().map(info -> info.id).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public static BossInfo getBossInfo(String bossID) {
        if (bossID == null) {
            return null;
        }
        for (List<BossInfo> infos : customBosses.values()) {
            for (BossInfo info : infos) {
                if (!bossID.equals(info.id)) continue;
                return info;
            }
        }
        return null;
    }

    public static void addKeyword(String[] names, String description) {
        BaseMod.addKeyword(null, names, description);
    }

    public static void addKeyword(String proper, String[] names, String description) {
        BaseMod.addKeyword(null, proper, names, description);
    }

    public static void addKeyword(String modID, String proper, String[] names, String description) {
        if (modID != null && !modID.isEmpty()) {
            if (!modID.endsWith(":")) {
                modID = modID + ":";
            }
            String uniqueParent = names[0];
            for (int i = 0; i < names.length; ++i) {
                names[i] = modID + names[i];
            }
            for (String name : names) {
                keywordUniqueNames.put(name, uniqueParent);
                keywordUniquePrefixes.put(name, modID);
            }
        }
        String parent = names[0];
        if (proper != null) {
            keywordProperNames.put(parent, proper);
        }
        for (String name : names) {
            GameDictionary.keywords.put(name, description);
            GameDictionary.parentWord.put(name, parent);
        }
    }

    public static String getKeywordProper(String keyword) {
        return keywordProperNames.get(keyword);
    }

    public static String getKeywordUnique(String keyword) {
        return keywordUniqueNames.get(keyword);
    }

    public static boolean keywordIsUnique(String keyword) {
        return keywordUniqueNames.containsKey(keyword);
    }

    public static String getKeywordPrefix(String keyword) {
        return keywordUniquePrefixes.get(keyword);
    }

    public static String getKeywordTitle(String keyword) {
        String title = BaseMod.getKeywordProper(keyword = (String)GameDictionary.parentWord.get(keyword));
        if (title != null) {
            return title;
        }
        return TipHelper.capitalize((String)keyword);
    }

    public static String getKeywordDescription(String keyword) {
        keyword = (String)GameDictionary.parentWord.get(keyword);
        return (String)GameDictionary.keywords.get(keyword);
    }

    public static void addUnlockBundle(CustomUnlockBundle bundle, AbstractPlayer.PlayerClass c, int unlockLevel) {
        if (bundle == null) {
            return;
        }
        if (!unlockBundles.containsKey(c)) {
            HashMap<Integer, CustomUnlockBundle> newBundles = new HashMap<Integer, CustomUnlockBundle>();
            newBundles.put(unlockLevel, bundle);
            unlockBundles.put(c, newBundles);
        } else {
            HashMap<Integer, CustomUnlockBundle> bundles = unlockBundles.get(c);
            bundles.put(unlockLevel, bundle);
        }
        if (bundle.unlockType == AbstractUnlock.UnlockType.CARD) {
            if (!unlockCards.containsKey(c)) {
                unlockCards.put(c, new ArrayList());
            }
            for (String s : bundle.getUnlockIDs()) {
                if (unlockCards.get(c).contains(s)) continue;
                unlockCards.get(c).add(s);
            }
        }
        if (maxUnlockLevel.containsKey(c)) {
            maxUnlockLevel.put(c, Math.max(maxUnlockLevel.get(c), unlockLevel + 1));
        } else {
            maxUnlockLevel.put(c, unlockLevel + 1);
        }
    }

    public static void removeUnlockBundle(AbstractPlayer.PlayerClass c, int unlockLevel) {
        if (unlockBundles.containsKey(c)) {
            unlockBundles.get(c).remove(unlockLevel);
        }
    }

    public static CustomUnlockBundle getUnlockBundleFor(AbstractPlayer.PlayerClass c, int unlockLevel) {
        HashMap<Integer, CustomUnlockBundle> levelMap = unlockBundles.get(c);
        if (levelMap == null) {
            return null;
        }
        return levelMap.get(unlockLevel);
    }

    public static ArrayList<String> getUnlockCards(AbstractPlayer.PlayerClass c) {
        return unlockCards.get(c);
    }

    public static int getMaxUnlockLevel(AbstractPlayer p) {
        return BaseMod.getMaxUnlockLevel(p.chosenClass);
    }

    public static int getMaxUnlockLevel(AbstractPlayer.PlayerClass c) {
        if (maxUnlockLevel.containsKey(c)) {
            return maxUnlockLevel.get(c);
        }
        return 0;
    }

    public static AbstractPlayer findCharacter(AbstractPlayer.PlayerClass playerClass) {
        for (AbstractPlayer character : CardCrawlGame.characterManager.getAllCharacters()) {
            if (character.chosenClass != playerClass) continue;
            return character;
        }
        return null;
    }

    public static List<AbstractPlayer> getModdedCharacters() {
        return CardCrawlGame.characterManager.getAllCharacters().subList(lastBaseCharacterIndex + 1, CardCrawlGame.characterManager.getAllCharacters().size());
    }

    public static void addCharacter(AbstractPlayer character, String selectButtonPath, String portraitPath, AbstractPlayer.PlayerClass characterID, String customModeButtonPath) {
        CardCrawlGame.characterManager.getAllCharacters().add(character);
        playerSelectButtonMap.put(characterID, selectButtonPath);
        customModeCharacterButtonMap.put(characterID, customModeButtonPath);
        playerPortraitMap.put(characterID, portraitPath);
    }

    public static void addCharacter(AbstractPlayer character, String selectButtonPath, String portraitPath, AbstractPlayer.PlayerClass characterID) {
        BaseMod.addCharacter(character, selectButtonPath, portraitPath, characterID, null);
    }

    public static TextureAtlas.AtlasRegion getCardSmallEnergy() {
        if (AbstractDungeon.player == null) {
            return AbstractCard.orb_red;
        }
        return AbstractDungeon.player.getOrb();
    }

    public static TextureAtlas.AtlasRegion getCardSmallEnergy(AbstractCard card) {
        switch (card.color) {
            case RED: {
                return AbstractCard.orb_red;
            }
            case GREEN: {
                return AbstractCard.orb_green;
            }
            case BLUE: {
                return AbstractCard.orb_blue;
            }
            case PURPLE: {
                return AbstractCard.orb_purple;
            }
            case COLORLESS: {
                return BaseMod.getCardSmallEnergy();
            }
        }
        return BaseMod.getCardEnergyOrbAtlasRegion(card.color);
    }

    public static String getPlayerButton(AbstractPlayer.PlayerClass playerClass) {
        return playerSelectButtonMap.get(playerClass);
    }

    public static String getCustomModePlayerButton(AbstractPlayer.PlayerClass playerClass) {
        return customModeCharacterButtonMap.get(playerClass);
    }

    public static String getPlayerPortrait(AbstractPlayer.PlayerClass playerClass) {
        return playerPortraitMap.get(playerClass);
    }

    public static ArrayList<CharacterOption> generateCharacterOptions() {
        ArrayList<CharacterOption> options = new ArrayList<CharacterOption>();
        for (AbstractPlayer character : BaseMod.getModdedCharacters()) {
            CharacterOption option = new CharacterOption(character.getLocalizedCharacterName(), CardCrawlGame.characterManager.recreateCharacter(character.chosenClass), ImageMaster.loadImage((String)playerSelectButtonMap.get(character.chosenClass)), ImageMaster.loadImage((String)playerPortraitMap.get(character.chosenClass)));
            options.add(option);
        }
        options.sort(Comparator.comparing(o -> o.name));
        return options;
    }

    public static ArrayList<CustomModeCharacterButton> generateCustomCharacterOptions() {
        ArrayList<CustomModeCharacterButton> options = new ArrayList<CustomModeCharacterButton>();
        for (AbstractPlayer character : BaseMod.getModdedCharacters()) {
            options.add(new CustomModeCharacterButton(CardCrawlGame.characterManager.setChosenCharacter(character.chosenClass), false));
        }
        return options;
    }

    public static void addColor(AbstractCard.CardColor color, Color everythingColor, String attackBg, String skillBg, String powerBg, String energyOrb, String attackBgPortrait, String skillBgPortrait, String powerBgPortrait, String energyOrbPortrait, String cardEnergyOrb) {
        BaseMod.addColor(color, everythingColor, everythingColor, everythingColor, everythingColor, everythingColor, everythingColor, everythingColor, attackBg, skillBg, powerBg, energyOrb, attackBgPortrait, skillBgPortrait, powerBgPortrait, energyOrbPortrait, cardEnergyOrb);
    }

    public static void addColor(AbstractCard.CardColor color, Color bgColor, Color backColor, Color frameColor, Color frameOutlineColor, Color descBoxColor, Color trailVfxColor, Color glowColor, String attackBg, String skillBg, String powerBg, String energyOrb, String attackBgPortrait, String skillBgPortrait, String powerBgPortrait, String energyOrbPortrait) {
        BaseMod.addColor(color, bgColor, backColor, frameColor, frameOutlineColor, descBoxColor, trailVfxColor, glowColor, attackBg, skillBg, powerBg, energyOrb, attackBgPortrait, skillBgPortrait, powerBgPortrait, energyOrbPortrait, null);
    }

    public static void addColor(AbstractCard.CardColor color, Color bgColor, Color backColor, Color frameColor, Color frameOutlineColor, Color descBoxColor, Color trailVfxColor, Color glowColor, String attackBg, String skillBg, String powerBg, String energyOrb, String attackBgPortrait, String skillBgPortrait, String powerBgPortrait, String energyOrbPortrait, String cardEnergyOrb) {
        colorBgColorMap.put(color, bgColor);
        colorBackColorMap.put(color, backColor);
        colorFrameColorMap.put(color, frameColor);
        colorFrameOutlineColorMap.put(color, frameOutlineColor);
        colorDescBoxColorMap.put(color, descBoxColor);
        colorTrailVfxMap.put(color, trailVfxColor);
        colorGlowColorMap.put(color, glowColor);
        colorCardCountMap.put(color, 0);
        colorCardSeenCountMap.put(color, 0);
        colorAttackBgMap.put(color, attackBg);
        colorSkillBgMap.put(color, skillBg);
        colorPowerBgMap.put(color, powerBg);
        colorEnergyOrbMap.put(color, energyOrb);
        colorAttackBgPortraitMap.put(color, attackBgPortrait);
        colorSkillBgPortraitMap.put(color, skillBgPortrait);
        colorPowerBgPortraitMap.put(color, powerBgPortrait);
        colorEnergyOrbPortraitMap.put(color, energyOrbPortrait);
        colorCardEnergyOrbMap.put(color, cardEnergyOrb);
        customRelicPools.put(color, new HashMap());
        customRelicLists.put(color, new ArrayList());
    }

    public static void removeColor(AbstractCard.CardColor color) {
        colorBgColorMap.remove(color);
        colorBackColorMap.remove(color);
        colorFrameColorMap.remove(color);
        colorFrameOutlineColorMap.remove(color);
        colorDescBoxColorMap.remove(color);
        colorTrailVfxMap.remove(color);
        colorGlowColorMap.remove(color);
        colorCardCountMap.remove(color);
        colorCardSeenCountMap.remove(color);
        colorAttackBgMap.remove(color);
        colorSkillBgMap.remove(color);
        colorPowerBgMap.remove(color);
        colorEnergyOrbMap.remove(color);
        colorCardEnergyOrbMap.remove(color);
        colorAttackBgPortraitMap.remove(color);
        colorSkillBgPortraitMap.remove(color);
        colorPowerBgPortraitMap.remove(color);
        colorEnergyOrbPortraitMap.remove(color);
        customRelicPools.remove(color);
        customRelicLists.remove(color, new ArrayList());
    }

    public static List<AbstractCard.CardColor> getCardColors() {
        return new ArrayList<AbstractCard.CardColor>(colorTrailVfxMap.keySet());
    }

    public static Color getBgColor(AbstractCard.CardColor color) {
        return colorBgColorMap.get(color);
    }

    public static Color getBackColor(AbstractCard.CardColor color) {
        return colorBackColorMap.get(color);
    }

    public static Color getFrameColor(AbstractCard.CardColor color) {
        return colorFrameColorMap.get(color);
    }

    public static Color getFrameOutlineColor(AbstractCard.CardColor color) {
        return colorFrameOutlineColorMap.get(color);
    }

    public static Color getDescBoxColor(AbstractCard.CardColor color) {
        return colorDescBoxColorMap.get(color);
    }

    public static Color getTrailVfxColor(AbstractCard.CardColor color) {
        return colorTrailVfxMap.get(color);
    }

    public static void incrementCardCount(AbstractCard.CardColor color) {
        Integer count = colorCardCountMap.get(color);
        if (count != null) {
            colorCardCountMap.put(color, count + 1);
        } else {
            colorCardCountMap.put(color, 0);
        }
    }

    public static void decrementCardCount(AbstractCard.CardColor color) {
        Integer count = colorCardCountMap.get(color);
        if (count != null) {
            colorCardCountMap.put(color, count - 1);
            if (colorCardCountMap.get(color) < 0) {
                colorCardCountMap.remove(color);
            }
        }
    }

    public static int getCardCount(AbstractCard.CardColor color) {
        Integer count = colorCardCountMap.get(color);
        if (count == null) {
            return -1;
        }
        return count;
    }

    public static void incrementSeenCardCount(AbstractCard.CardColor color) {
        Integer count = colorCardSeenCountMap.get(color);
        if (count != null) {
            colorCardSeenCountMap.put(color, count + 1);
        } else {
            colorCardSeenCountMap.put(color, 0);
        }
    }

    public static int getSeenCardCount(AbstractCard.CardColor color) {
        Integer count = colorCardSeenCountMap.get(color);
        if (count == null) {
            return -1;
        }
        return count;
    }

    public static Color getGlowColor(AbstractCard.CardColor color) {
        return colorGlowColorMap.get(color);
    }

    public static String getAttackBg(AbstractCard.CardColor color) {
        return colorAttackBgMap.get(color);
    }

    public static String getSkillBg(AbstractCard.CardColor color) {
        return colorSkillBgMap.get(color);
    }

    public static String getPowerBg(AbstractCard.CardColor color) {
        return colorPowerBgMap.get(color);
    }

    public static String getEnergyOrb(AbstractCard.CardColor color) {
        return colorEnergyOrbMap.get(color);
    }

    public static String getAttackBgPortrait(AbstractCard.CardColor color) {
        return colorAttackBgPortraitMap.get(color);
    }

    public static String getSkillBgPortrait(AbstractCard.CardColor color) {
        return colorSkillBgPortraitMap.get(color);
    }

    public static String getPowerBgPortrait(AbstractCard.CardColor color) {
        return colorPowerBgPortraitMap.get(color);
    }

    public static String getEnergyOrbPortrait(AbstractCard.CardColor color) {
        return colorEnergyOrbPortraitMap.get(color);
    }

    public static Texture getAttackBgTexture(AbstractCard.CardColor color) {
        return colorAttackBgTextureMap.get(color);
    }

    public static Texture getSkillBgTexture(AbstractCard.CardColor color) {
        return colorSkillBgTextureMap.get(color);
    }

    public static Texture getPowerBgTexture(AbstractCard.CardColor color) {
        return colorPowerBgTextureMap.get(color);
    }

    public static Texture getEnergyOrbTexture(AbstractCard.CardColor color) {
        return colorEnergyOrbTextureMap.get(color);
    }

    public static TextureAtlas.AtlasRegion getCardEnergyOrbAtlasRegion(AbstractCard.CardColor color) {
        TextureAtlas.AtlasRegion orb = colorCardEnergyOrbAtlasRegionMap.get(color);
        if (orb != null) {
            return orb;
        }
        String orbFile = colorCardEnergyOrbMap.get(color);
        if (orbFile != null) {
            Texture orbTexture = ImageMaster.loadImage((String)orbFile);
            int tw = orbTexture.getWidth();
            int th = orbTexture.getHeight();
            orb = new TextureAtlas.AtlasRegion(orbTexture, 0, 0, tw, th);
            colorCardEnergyOrbAtlasRegionMap.put(color, orb);
            return orb;
        }
        return AbstractCard.orb_red;
    }

    public static Texture getAttackBgPortraitTexture(AbstractCard.CardColor color) {
        return colorAttackBgPortraitTextureMap.get(color);
    }

    public static Texture getSkillBgPortraitTexture(AbstractCard.CardColor color) {
        return colorSkillBgPortraitTextureMap.get(color);
    }

    public static Texture getPowerBgPortraitTexture(AbstractCard.CardColor color) {
        return colorPowerBgPortraitTextureMap.get(color);
    }

    public static Texture getEnergyOrbPortraitTexture(AbstractCard.CardColor color) {
        return colorEnergyOrbPortraitTextureMap.get(color);
    }

    public static void saveAttackBgTexture(AbstractCard.CardColor color, Texture tex) {
        colorAttackBgTextureMap.put(color, tex);
    }

    public static void saveSkillBgTexture(AbstractCard.CardColor color, Texture tex) {
        colorSkillBgTextureMap.put(color, tex);
    }

    public static void savePowerBgTexture(AbstractCard.CardColor color, Texture tex) {
        colorPowerBgTextureMap.put(color, tex);
    }

    public static void saveEnergyOrbTexture(AbstractCard.CardColor color, Texture tex) {
        colorEnergyOrbTextureMap.put(color, tex);
    }

    public static void saveAttackBgPortraitTexture(AbstractCard.CardColor color, Texture tex) {
        colorAttackBgPortraitTextureMap.put(color, tex);
    }

    public static void saveSkillBgPortraitTexture(AbstractCard.CardColor color, Texture tex) {
        colorSkillBgPortraitTextureMap.put(color, tex);
    }

    public static void savePowerBgPortraitTexture(AbstractCard.CardColor color, Texture tex) {
        colorPowerBgPortraitTextureMap.put(color, tex);
    }

    public static void saveEnergyOrbPortraitTexture(AbstractCard.CardColor color, Texture tex) {
        colorEnergyOrbPortraitTextureMap.put(color, tex);
    }

    public static ArrayList<String> getPotionsToRemove() {
        return potionsToRemove;
    }

    public static void removePotion(String potionID) {
        potionsToRemove.add(potionID);
    }

    public static void addPotion(Class<? extends AbstractPotion> potionClass, Color liquidColor, Color hybridColor, Color spotsColor, String potionID) {
        BaseMod.addPotion(potionClass, liquidColor, hybridColor, spotsColor, potionID, null);
    }

    public static void addPotion(Class<? extends AbstractPotion> potionClass, Color liquidColor, Color hybridColor, Color spotsColor, String potionID, AbstractPlayer.PlayerClass playerClass) {
        potionClassMap.put(potionID, potionClass);
        potionLiquidColorMap.put(potionID, liquidColor);
        potionHybridColorMap.put(potionID, hybridColor);
        potionSpotsColorMap.put(potionID, spotsColor);
        potionPlayerClassMap.put(potionID, playerClass);
    }

    public static Class<? extends AbstractPotion> getPotionClass(String potionID) {
        return potionClassMap.get(potionID);
    }

    public static Color getPotionLiquidColor(String potionID) {
        return potionLiquidColorMap.get(potionID);
    }

    public static Color getPotionHybridColor(String potionID) {
        return potionHybridColorMap.get(potionID);
    }

    public static Color getPotionSpotsColor(String potionID) {
        return potionSpotsColorMap.get(potionID);
    }

    public static AbstractPlayer.PlayerClass getPotionPlayerClass(String potionID) {
        return potionPlayerClassMap.get(potionID);
    }

    public static Set<String> getPotionIDs() {
        return potionClassMap.keySet();
    }

    public static void addPower(Class<? extends AbstractPower> powerClass, String powerID) {
        powerMap.put(powerID, powerClass);
        if (powerID.contains(" ")) {
            underScorePowerIDs.put(powerID.replace(' ', '_'), powerID);
        }
    }

    public static Class<? extends AbstractPower> getPowerClass(String powerID) {
        return powerMap.get(powerID);
    }

    public static Set<String> getPowerKeys() {
        return powerMap.keySet();
    }

    public static <T> void addSaveField(String key, CustomSavableRaw saveField) {
        customSaveFields.put(key, saveField);
    }

    public static Map<String, CustomSavableRaw> getSaveFields() {
        return customSaveFields;
    }

    public static void setRichPresence(String msg) {
        if (CardCrawlGame.publisherIntegration == null) {
            return;
        }
        if (!(CardCrawlGame.publisherIntegration instanceof SteamIntegration)) {
            return;
        }
        try {
            Method m = SteamIntegration.class.getDeclaredMethod("setRichPresenceData", String.class, String.class);
            m.setAccessible(true);
            m.invoke((Object)CardCrawlGame.publisherIntegration, "status", msg);
            m.invoke((Object)CardCrawlGame.publisherIntegration, "steam_display", "#Status");
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void publishStartAct() {
        logger.info("publishStartAct");
        for (StartActSubscriber sub : startActSubscribers) {
            sub.receiveStartAct();
        }
        BaseMod.unsubscribeLaterHelper(StartActSubscriber.class);
    }

    public static boolean publishPostCampfire() {
        logger.info("publishPostCampfire");
        boolean campfireDone = true;
        for (PostCampfireSubscriber sub : postCampfireSubscribers) {
            if (sub.receivePostCampfire()) continue;
            campfireDone = false;
        }
        BaseMod.unsubscribeLaterHelper(PostCampfireSubscriber.class);
        return campfireDone;
    }

    public static void publishPostDraw(AbstractCard c) {
        logger.info("publishPostDraw");
        for (PostDrawSubscriber sub : postDrawSubscribers) {
            sub.receivePostDraw(c);
        }
        BaseMod.unsubscribeLaterHelper(PostDrawSubscriber.class);
    }

    public static void publishPostExhaust(AbstractCard c) {
        logger.info("publishPostExhaust");
        for (PostExhaustSubscriber sub : postExhaustSubscribers) {
            sub.receivePostExhaust(c);
        }
        BaseMod.unsubscribeLaterHelper(PostExhaustSubscriber.class);
    }

    public static void publishPostDungeonInitialize() {
        logger.info("publishPostDungeonInitialize");
        for (PostDungeonInitializeSubscriber sub : postDungeonInitializeSubscribers) {
            sub.receivePostDungeonInitialize();
        }
        BaseMod.unsubscribeLaterHelper(PostDungeonInitializeSubscriber.class);
    }

    public static void publishPostEnergyRecharge() {
        logger.info("publishPostEnergyRecharge");
        for (PostEnergyRechargeSubscriber sub : postEnergyRechargeSubscribers) {
            sub.receivePostEnergyRecharge();
        }
        BaseMod.unsubscribeLaterHelper(PostEnergyRechargeSubscriber.class);
    }

    public static void publishPostInitialize() {
        logger.info("publishPostInitialize");
        BaseMod.setupAnimationGfx();
        for (PostInitializeSubscriber sub : postInitializeSubscribers) {
            sub.receivePostInitialize();
        }
        BaseMod.unsubscribeLaterHelper(PostInitializeSubscriber.class);
    }

    public static boolean publishPreMonsterTurn(AbstractMonster m) {
        logger.info("publishPreMonsterTurn");
        boolean takeTurn = true;
        for (PreMonsterTurnSubscriber sub : preMonsterTurnSubscribers) {
            if (sub.receivePreMonsterTurn(m)) continue;
            takeTurn = false;
        }
        BaseMod.unsubscribeLaterHelper(PreMonsterTurnSubscriber.class);
        return takeTurn;
    }

    public static void publishRender(SpriteBatch sb) {
        for (RenderSubscriber sub : renderSubscribers) {
            sub.receiveRender(sb);
        }
        BaseMod.unsubscribeLaterHelper(RenderSubscriber.class);
    }

    public static void publishAnimationRender(SpriteBatch sb) {
        if (modelRenderSubscribers.size() > 0) {
            sb.end();
            CardCrawlGame.psb.begin();
            CardCrawlGame.psb.setBlendFunction(1, 771);
            CardCrawlGame.psb.draw(animationTextureRegion, 0.0f, 0.0f);
            CardCrawlGame.psb.setBlendFunction(770, 771);
            CardCrawlGame.psb.end();
            sb.begin();
        }
    }

    public static void publishPreRender(OrthographicCamera camera) {
        for (PreRenderSubscriber preRenderSubscriber : preRenderSubscribers) {
            preRenderSubscriber.receiveCameraRender(camera);
        }
        if (modelRenderSubscribers.size() > 0) {
            animationBuffer.begin();
            Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            Gdx.gl.glClear(16384);
            batch.begin((Camera)animationCamera);
            for (ModelRenderSubscriber modelRenderSubscriber : modelRenderSubscribers) {
                modelRenderSubscriber.receiveModelRender(batch, animationEnvironment);
            }
            batch.end();
            animationBuffer.end();
            animationTexture = (Texture)animationBuffer.getColorBufferTexture();
            animationTextureRegion = new TextureRegion(animationTexture);
            animationTextureRegion.flip(false, true);
        }
        BaseMod.unsubscribeLaterHelper(PreRenderSubscriber.class);
        BaseMod.unsubscribeLaterHelper(ModelRenderSubscriber.class);
    }

    public static void publishPostRender(SpriteBatch sb) {
        for (PostRenderSubscriber sub : postRenderSubscribers) {
            sub.receivePostRender(sb);
        }
        BaseMod.unsubscribeLaterHelper(PostRenderSubscriber.class);
    }

    public static void publishPreStartGame() {
        logger.info("publishPreStartGame");
        MAX_HAND_SIZE = 10;
        for (PreStartGameSubscriber sub : preStartGameSubscribers) {
            sub.receivePreStartGame();
        }
        BaseMod.unsubscribeLaterHelper(PreStartGameSubscriber.class);
    }

    public static void publishStartGame() {
        logger.info("publishStartGame");
        for (StartGameSubscriber sub : startGameSubscribers) {
            sub.receiveStartGame();
        }
        logger.info("mapDensityMultiplier: " + mapPathDensityMultiplier);
        BaseMod.unsubscribeLaterHelper(StartGameSubscriber.class);
    }

    public static void publishPreUpdate() {
        for (PreUpdateSubscriber sub : preUpdateSubscribers) {
            sub.receivePreUpdate();
        }
        BaseMod.unsubscribeLaterHelper(PreUpdateSubscriber.class);
    }

    public static void publishPostUpdate() {
        for (PostUpdateSubscriber sub : postUpdateSubscribers) {
            sub.receivePostUpdate();
        }
        BaseMod.unsubscribeLaterHelper(PostUpdateSubscriber.class);
    }

    public static void publishPostDungeonUpdate() {
        for (PostDungeonUpdateSubscriber sub : postDungeonUpdateSubscribers) {
            sub.receivePostDungeonUpdate();
        }
        BaseMod.unsubscribeLaterHelper(PostDungeonUpdateSubscriber.class);
    }

    public static void publishPreDungeonUpdate() {
        for (PreDungeonUpdateSubscriber sub : preDungeonUpdateSubscribers) {
            sub.receivePreDungeonUpdate();
        }
        BaseMod.unsubscribeLaterHelper(PreDungeonUpdateSubscriber.class);
    }

    public static void publishPostPlayerUpdate() {
        for (PostPlayerUpdateSubscriber sub : postPlayerUpdateSubscribers) {
            sub.receivePostPlayerUpdate();
        }
        BaseMod.unsubscribeLaterHelper(PostPlayerUpdateSubscriber.class);
    }

    public static void publishPrePlayerUpdate() {
        for (PrePlayerUpdateSubscriber sub : prePlayerUpdateSubscribers) {
            sub.receivePrePlayerUpdate();
        }
        BaseMod.unsubscribeLaterHelper(PrePlayerUpdateSubscriber.class);
    }

    public static void publishPostCreateStartingDeck(AbstractPlayer.PlayerClass chosenClass, CardGroup cards) {
        logger.info("postCreateStartingDeck for: " + chosenClass);
        for (PostCreateStartingDeckSubscriber sub : postCreateStartingDeckSubscribers) {
            logger.info("postCreateStartingDeck modifying starting deck for: " + sub);
            sub.receivePostCreateStartingDeck(chosenClass, cards);
        }
        StringBuilder logString = new StringBuilder("postCreateStartingDeck adding [ ");
        for (AbstractCard card : cards.group) {
            logString.append(card.cardID).append(" ");
        }
        logString.append("]");
        logger.info(logString.toString());
        BaseMod.unsubscribeLaterHelper(PostCreateStartingDeckSubscriber.class);
    }

    public static void publishPostCreateStartingRelics(AbstractPlayer.PlayerClass chosenClass, ArrayList<String> relics) {
        logger.info("postCreateStartingRelics for: " + chosenClass);
        for (PostCreateStartingRelicsSubscriber sub : postCreateStartingRelicsSubscribers) {
            logger.info("postCreateStartingRelics modifying starting relics for: " + sub);
            sub.receivePostCreateStartingRelics(chosenClass, relics);
        }
        StringBuilder logString = new StringBuilder("postCreateStartingRelics adding [ ");
        for (String relic : relics) {
            logString.append(relic).append(" ");
        }
        logString.append("]");
        logger.info(logString.toString());
        for (String relic : relics) {
            UnlockTracker.markRelicAsSeen((String)relic);
        }
        AbstractDungeon.relicsToRemoveOnStart.addAll(relics);
        BaseMod.unsubscribeLaterHelper(PostCreateStartingRelicsSubscriber.class);
    }

    public static void publishPostCreateShopRelics(ArrayList<StoreRelic> relics, ShopScreen screenInstance) {
        logger.info("postCreateShopRelics for: " + relics);
        for (PostCreateShopRelicSubscriber sub : postCreateShopRelicSubscribers) {
            sub.receiveCreateShopRelics(relics, screenInstance);
        }
        BaseMod.unsubscribeLaterHelper(PostCreateShopRelicSubscriber.class);
    }

    public static void publishPostCreateShopPotions(ArrayList<StorePotion> potions, ShopScreen screenInstance) {
        logger.info("postCreateShopPotions for: " + potions);
        for (PostCreateShopPotionSubscriber sub : postCreateShopPotionSubscribers) {
            sub.receiveCreateShopPotions(potions, screenInstance);
        }
        BaseMod.unsubscribeLaterHelper(PostCreateShopPotionSubscriber.class);
    }

    public static void publishEditCards() {
        logger.info("begin editing cards");
        BaseMod.addDynamicVariable(new DamageVariable());
        BaseMod.addDynamicVariable(new BlockVariable());
        BaseMod.addDynamicVariable(new MagicNumberVariable());
        for (EditCardsSubscriber sub : editCardsSubscribers) {
            sub.receiveEditCards();
        }
        BaseMod.unsubscribeLaterHelper(EditCardsSubscriber.class);
    }

    public static void publishEditRelics() {
        logger.info("begin editing relics");
        for (EditRelicsSubscriber sub : editRelicsSubscribers) {
            sub.receiveEditRelics();
        }
        BaseMod.unsubscribeLaterHelper(EditRelicsSubscriber.class);
    }

    public static void publishEditCharacters() {
        logger.info("begin editing characters");
        lastBaseCharacterIndex = CardCrawlGame.characterManager.getAllCharacters().size() - 1;
        for (EditCharactersSubscriber sub : editCharactersSubscribers) {
            sub.receiveEditCharacters();
        }
        BaseMod.unsubscribeLaterHelper(EditCharactersSubscriber.class);
    }

    public static void publishEditStrings() {
        logger.info("begin editing localization strings");
        EventUtils.loadBaseEvents();
        String path = String.format("localization/basemod/%s/customMods.json", Settings.language.name().toLowerCase());
        if (!Gdx.files.internal(path).exists()) {
            path = String.format("localization/basemod/%s/customMods.json", Settings.GameLanguage.ENG.name().toLowerCase());
        }
        BaseMod.loadCustomStringsFile(RunModStrings.class, path);
        for (EditStringsSubscriber sub : editStringsSubscribers) {
            sub.receiveEditStrings();
        }
        BaseMod.unsubscribeLaterHelper(EditStringsSubscriber.class);
    }

    public static void publishAddAudio(SoundMaster __instance) {
        logger.info("begin adding custom sounds");
        for (AddAudioSubscriber sub : addAudioSubscribers) {
            sub.receiveAddAudio();
        }
        BaseMod.addAudioToSoundMaster(__instance);
        BaseMod.unsubscribeLaterHelper(AddAudioSubscriber.class);
    }

    public static void publishPostBattle(AbstractRoom battleRoom) {
        logger.info("publish post combat");
        for (PostBattleSubscriber sub : postBattleSubscribers) {
            sub.receivePostBattle(battleRoom);
        }
        BaseMod.unsubscribeLaterHelper(PostBattleSubscriber.class);
    }

    public static void publishStartBattle(AbstractRoom room) {
        logger.info("publish start battle");
        for (OnStartBattleSubscriber sub : startBattleSubscribers) {
            sub.receiveOnBattleStart(room);
        }
        BaseMod.unsubscribeLaterHelper(OnStartBattleSubscriber.class);
    }

    public static void publishPostRefresh() {
        logger.info("publish post refresh - refreshing unlocks");
        for (SetUnlocksSubscriber sub : setUnlocksSubscribers) {
            sub.receiveSetUnlocks();
        }
        CountModdedUnlockCards.enabled = true;
        CountModdedUnlockCards.countModdedUnlocks();
        BaseMod.unsubscribeLaterHelper(SetUnlocksSubscriber.class);
    }

    public static void publishOnCardUse(AbstractCard c) {
        logger.info("publish on card use: " + (c == null ? "null" : c.cardID));
        for (OnCardUseSubscriber sub : onCardUseSubscribers) {
            sub.receiveCardUsed(c);
        }
        BaseMod.unsubscribeLaterHelper(OnCardUseSubscriber.class);
    }

    public static void publishPostPotionUse(AbstractPotion p) {
        logger.info("publish on post potion use");
        for (PostPotionUseSubscriber sub : postPotionUseSubscribers) {
            sub.receivePostPotionUse(p);
        }
        BaseMod.unsubscribeLaterHelper(PostPotionUseSubscriber.class);
    }

    public static void publishPrePotionUse(AbstractPotion p) {
        logger.info("publish on pre potion use");
        for (PrePotionUseSubscriber sub : prePotionUseSubscribers) {
            sub.receivePrePotionUse(p);
        }
        BaseMod.unsubscribeLaterHelper(PrePotionUseSubscriber.class);
    }

    public static void publishPotionGet(AbstractPotion p) {
        logger.info("publish on potion get");
        for (PotionGetSubscriber sub : potionGetSubscribers) {
            sub.receivePotionGet(p);
        }
        BaseMod.unsubscribeLaterHelper(PotionGetSubscriber.class);
    }

    public static void publishRelicGet(AbstractRelic r) {
        logger.info("publish on relic get");
        for (RelicGetSubscriber sub : relicGetSubscribers) {
            sub.receiveRelicGet(r);
        }
        BaseMod.unsubscribeLaterHelper(RelicGetSubscriber.class);
    }

    public static void publishPostPowerApply(AbstractPower p, AbstractCreature target, AbstractCreature source) {
        logger.info("publish on post power apply");
        for (PostPowerApplySubscriber sub : postPowerApplySubscribers) {
            sub.receivePostPowerApplySubscriber(p, target, source);
        }
        BaseMod.unsubscribeLaterHelper(PostPowerApplySubscriber.class);
    }

    public static void publishEditKeywords() {
        logger.info("editting keywords");
        BaseMod.addKeyword(new String[]{"[E]"}, GameDictionary.TEXT[0]);
        for (EditKeywordsSubscriber sub : editKeywordsSubscribers) {
            sub.receiveEditKeywords();
        }
        BaseMod.unsubscribeLaterHelper(EditKeywordsSubscriber.class);
    }

    public static void publishOnPowersModified() {
        logger.info("powers modified");
        for (OnPowersModifiedSubscriber sub : onPowersModifiedSubscribers) {
            sub.receivePowersModified();
        }
        BaseMod.unsubscribeLaterHelper(OnPowersModifiedSubscriber.class);
    }

    public static void publishPostDeath() {
        logger.info("publishPostDeath");
        for (PostDeathSubscriber sub : postDeathSubscribers) {
            sub.receivePostDeath();
        }
        BaseMod.unsubscribeLaterHelper(PostDeathSubscriber.class);
    }

    public static void publishAddCustomModeMods(List<CustomMod> modList) {
        logger.info("publishAddCustomModeMods");
        CustomMod charMod = new CustomMod("Modded Character Cards", "p", false);
        for (AbstractPlayer character : BaseMod.getModdedCharacters()) {
            CustomMod mod = new CustomMod("Red Cards", "g", true);
            mod.ID = character.chosenClass.name() + charMod.name;
            mod.name = String.format(charMod.name, character.getLocalizedCharacterName());
            mod.description = String.format(charMod.description, character.getLocalizedCharacterName());
            String label = FontHelper.colorString((String)("[" + mod.name + "]"), (String)mod.color) + " " + mod.description;
            ReflectionHacks.setPrivate(mod, CustomMod.class, "label", label);
            float height = -FontHelper.getSmartHeight((BitmapFont)FontHelper.charDescFont, (String)label, (float)(1050.0f * Settings.scale), (float)(32.0f * Settings.scale)) + 70.0f * Settings.scale;
            ReflectionHacks.setPrivate(mod, CustomMod.class, "height", Float.valueOf(height));
            BaseMod.insertCustomMod(modList, mod);
        }
        for (AddCustomModeModsSubscriber sub : addCustomModeModsSubscribers) {
            ArrayList<CustomMod> tmpModList = new ArrayList<CustomMod>();
            sub.receiveCustomModeMods(tmpModList);
            tmpModList.forEach(m -> BaseMod.insertCustomMod(modList, m));
        }
        BaseMod.unsubscribeLaterHelper(AddCustomModeModsSubscriber.class);
    }

    private static void insertCustomMod(List<CustomMod> modList, CustomMod mod) {
        int lastIndex = modList.size();
        for (int i = 0; i < modList.size(); ++i) {
            if (!modList.get((int)i).color.equals(mod.color)) continue;
            lastIndex = i + 1;
        }
        modList.add(lastIndex, mod);
    }

    public static int publishMaxHPChange(int amount) {
        logger.info("publishMaxHPChange");
        for (MaxHPChangeSubscriber sub : maxHPChangeSubscribers) {
            amount = sub.receiveMapHPChange(amount);
        }
        BaseMod.unsubscribeLaterHelper(PostDeathSubscriber.class);
        return amount;
    }

    public static void publishPreRoomRender(SpriteBatch sb) {
        for (PreRoomRenderSubscriber sub : preRoomRenderSubscribers) {
            sub.receivePreRoomRender(sb);
        }
    }

    public static int publishOnPlayerLoseBlock(int amount) {
        logger.info("publish on Player Lose Block");
        for (OnPlayerLoseBlockSubscriber sub : onPlayerLoseBlockSubscribers) {
            amount = sub.receiveOnPlayerLoseBlock(amount);
        }
        BaseMod.unsubscribeLaterHelper(OnPlayerLoseBlockSubscriber.class);
        return amount;
    }

    public static int publishOnPlayerDamaged(int amount, DamageInfo info) {
        logger.info("publish on Player Damaged");
        for (OnPlayerDamagedSubscriber sub : onPlayerDamagedSubscribers) {
            amount = sub.receiveOnPlayerDamaged(amount, info);
        }
        BaseMod.unsubscribeLaterHelper(OnPlayerDamagedSubscriber.class);
        return amount;
    }

    public static String publishOnCreateDescription(String rawDescription, AbstractCard card) {
        for (OnCreateDescriptionSubscriber sub : onCreateDescriptionSubscribers) {
            rawDescription = sub.receiveCreateCardDescription(rawDescription, card);
        }
        BaseMod.unsubscribeLaterHelper(OnCreateDescriptionSubscriber.class);
        return rawDescription;
    }

    private static void unsubscribeLaterHelper(Class<? extends ISubscriber> removalClass) {
        for (ISubscriber sub : toRemove) {
            if (!removalClass.isInstance(sub)) continue;
            BaseMod.unsubscribe(sub, removalClass);
        }
    }

    private static <T> void subscribeIfInstance(ArrayList<T> list, ISubscriber sub, Class<T> clazz) {
        if (clazz.isInstance(sub)) {
            list.add(clazz.cast(sub));
        }
    }

    private static <T> void unsubscribeIfInstance(ArrayList<T> list, ISubscriber sub, Class<T> clazz) {
        if (clazz.isInstance(sub)) {
            list.remove(clazz.cast(sub));
        }
    }

    public static void subscribe(ISubscriber sub) {
        BaseMod.subscribeIfInstance(startActSubscribers, sub, StartActSubscriber.class);
        BaseMod.subscribeIfInstance(postCampfireSubscribers, sub, PostCampfireSubscriber.class);
        BaseMod.subscribeIfInstance(postDrawSubscribers, sub, PostDrawSubscriber.class);
        BaseMod.subscribeIfInstance(postExhaustSubscribers, sub, PostExhaustSubscriber.class);
        BaseMod.subscribeIfInstance(onCardUseSubscribers, sub, OnCardUseSubscriber.class);
        BaseMod.subscribeIfInstance(postDungeonInitializeSubscribers, sub, PostDungeonInitializeSubscriber.class);
        BaseMod.subscribeIfInstance(postEnergyRechargeSubscribers, sub, PostEnergyRechargeSubscriber.class);
        BaseMod.subscribeIfInstance(postInitializeSubscribers, sub, PostInitializeSubscriber.class);
        BaseMod.subscribeIfInstance(preMonsterTurnSubscribers, sub, PreMonsterTurnSubscriber.class);
        BaseMod.subscribeIfInstance(renderSubscribers, sub, RenderSubscriber.class);
        BaseMod.subscribeIfInstance(preRenderSubscribers, sub, PreRenderSubscriber.class);
        BaseMod.subscribeIfInstance(postRenderSubscribers, sub, PostRenderSubscriber.class);
        BaseMod.subscribeIfInstance(modelRenderSubscribers, sub, ModelRenderSubscriber.class);
        BaseMod.subscribeIfInstance(preStartGameSubscribers, sub, PreStartGameSubscriber.class);
        BaseMod.subscribeIfInstance(startGameSubscribers, sub, StartGameSubscriber.class);
        BaseMod.subscribeIfInstance(preUpdateSubscribers, sub, PreUpdateSubscriber.class);
        BaseMod.subscribeIfInstance(postUpdateSubscribers, sub, PostUpdateSubscriber.class);
        BaseMod.subscribeIfInstance(postDungeonUpdateSubscribers, sub, PostDungeonUpdateSubscriber.class);
        BaseMod.subscribeIfInstance(preDungeonUpdateSubscribers, sub, PreDungeonUpdateSubscriber.class);
        BaseMod.subscribeIfInstance(postPlayerUpdateSubscribers, sub, PostPlayerUpdateSubscriber.class);
        BaseMod.subscribeIfInstance(prePlayerUpdateSubscribers, sub, PrePlayerUpdateSubscriber.class);
        BaseMod.subscribeIfInstance(postCreateStartingDeckSubscribers, sub, PostCreateStartingDeckSubscriber.class);
        BaseMod.subscribeIfInstance(postCreateStartingRelicsSubscribers, sub, PostCreateStartingRelicsSubscriber.class);
        BaseMod.subscribeIfInstance(postCreateShopRelicSubscribers, sub, PostCreateShopRelicSubscriber.class);
        BaseMod.subscribeIfInstance(postCreateShopPotionSubscribers, sub, PostCreateShopPotionSubscriber.class);
        BaseMod.subscribeIfInstance(editCardsSubscribers, sub, EditCardsSubscriber.class);
        BaseMod.subscribeIfInstance(addAudioSubscribers, sub, AddAudioSubscriber.class);
        BaseMod.subscribeIfInstance(editRelicsSubscribers, sub, EditRelicsSubscriber.class);
        BaseMod.subscribeIfInstance(editCharactersSubscribers, sub, EditCharactersSubscriber.class);
        BaseMod.subscribeIfInstance(editStringsSubscribers, sub, EditStringsSubscriber.class);
        BaseMod.subscribeIfInstance(editKeywordsSubscribers, sub, EditKeywordsSubscriber.class);
        BaseMod.subscribeIfInstance(postBattleSubscribers, sub, PostBattleSubscriber.class);
        BaseMod.subscribeIfInstance(setUnlocksSubscribers, sub, SetUnlocksSubscriber.class);
        BaseMod.subscribeIfInstance(postPotionUseSubscribers, sub, PostPotionUseSubscriber.class);
        BaseMod.subscribeIfInstance(prePotionUseSubscribers, sub, PrePotionUseSubscriber.class);
        BaseMod.subscribeIfInstance(potionGetSubscribers, sub, PotionGetSubscriber.class);
        BaseMod.subscribeIfInstance(relicGetSubscribers, sub, RelicGetSubscriber.class);
        BaseMod.subscribeIfInstance(postPowerApplySubscribers, sub, PostPowerApplySubscriber.class);
        BaseMod.subscribeIfInstance(onPowersModifiedSubscribers, sub, OnPowersModifiedSubscriber.class);
        BaseMod.subscribeIfInstance(postDeathSubscribers, sub, PostDeathSubscriber.class);
        BaseMod.subscribeIfInstance(startBattleSubscribers, sub, OnStartBattleSubscriber.class);
        BaseMod.subscribeIfInstance(addCustomModeModsSubscribers, sub, AddCustomModeModsSubscriber.class);
        BaseMod.subscribeIfInstance(maxHPChangeSubscribers, sub, MaxHPChangeSubscriber.class);
        BaseMod.subscribeIfInstance(preRoomRenderSubscribers, sub, PreRoomRenderSubscriber.class);
        BaseMod.subscribeIfInstance(onPlayerLoseBlockSubscribers, sub, OnPlayerLoseBlockSubscriber.class);
        BaseMod.subscribeIfInstance(onPlayerDamagedSubscribers, sub, OnPlayerDamagedSubscriber.class);
        BaseMod.subscribeIfInstance(onCreateDescriptionSubscribers, sub, OnCreateDescriptionSubscriber.class);
    }

    public static void subscribe(ISubscriber sub, Class<? extends ISubscriber> additionClass) {
        if (additionClass.equals(StartActSubscriber.class)) {
            startActSubscribers.add((StartActSubscriber)sub);
        } else if (additionClass.equals(PostCampfireSubscriber.class)) {
            postCampfireSubscribers.add((PostCampfireSubscriber)sub);
        } else if (additionClass.equals(PostDrawSubscriber.class)) {
            postDrawSubscribers.add((PostDrawSubscriber)sub);
        } else if (additionClass.equals(PostExhaustSubscriber.class)) {
            postExhaustSubscribers.add((PostExhaustSubscriber)sub);
        } else if (additionClass.equals(OnCardUseSubscriber.class)) {
            onCardUseSubscribers.add((OnCardUseSubscriber)sub);
        } else if (additionClass.equals(PostDungeonInitializeSubscriber.class)) {
            postDungeonInitializeSubscribers.add((PostDungeonInitializeSubscriber)sub);
        } else if (additionClass.equals(PostEnergyRechargeSubscriber.class)) {
            postEnergyRechargeSubscribers.add((PostEnergyRechargeSubscriber)sub);
        } else if (additionClass.equals(PostInitializeSubscriber.class)) {
            postInitializeSubscribers.add((PostInitializeSubscriber)sub);
        } else if (additionClass.equals(PreMonsterTurnSubscriber.class)) {
            preMonsterTurnSubscribers.add((PreMonsterTurnSubscriber)sub);
        } else if (additionClass.equals(RenderSubscriber.class)) {
            renderSubscribers.add((RenderSubscriber)sub);
        } else if (additionClass.equals(PreRenderSubscriber.class)) {
            preRenderSubscribers.add((PreRenderSubscriber)sub);
        } else if (additionClass.equals(PostRenderSubscriber.class)) {
            postRenderSubscribers.add((PostRenderSubscriber)sub);
        } else if (additionClass.equals(ModelRenderSubscriber.class)) {
            modelRenderSubscribers.add((ModelRenderSubscriber)sub);
        } else if (additionClass.equals(PreStartGameSubscriber.class)) {
            preStartGameSubscribers.add((PreStartGameSubscriber)sub);
        } else if (additionClass.equals(StartGameSubscriber.class)) {
            startGameSubscribers.add((StartGameSubscriber)sub);
        } else if (additionClass.equals(PreUpdateSubscriber.class)) {
            preUpdateSubscribers.add((PreUpdateSubscriber)sub);
        } else if (additionClass.equals(PostUpdateSubscriber.class)) {
            postUpdateSubscribers.add((PostUpdateSubscriber)sub);
        } else if (additionClass.equals(PostDungeonUpdateSubscriber.class)) {
            postDungeonUpdateSubscribers.add((PostDungeonUpdateSubscriber)sub);
        } else if (additionClass.equals(PreDungeonUpdateSubscriber.class)) {
            preDungeonUpdateSubscribers.add((PreDungeonUpdateSubscriber)sub);
        } else if (additionClass.equals(PostPlayerUpdateSubscriber.class)) {
            postPlayerUpdateSubscribers.add((PostPlayerUpdateSubscriber)sub);
        } else if (additionClass.equals(PrePlayerUpdateSubscriber.class)) {
            prePlayerUpdateSubscribers.add((PrePlayerUpdateSubscriber)sub);
        } else if (additionClass.equals(PostCreateStartingDeckSubscriber.class)) {
            postCreateStartingDeckSubscribers.add((PostCreateStartingDeckSubscriber)sub);
        } else if (additionClass.equals(PostCreateStartingRelicsSubscriber.class)) {
            postCreateStartingRelicsSubscribers.add((PostCreateStartingRelicsSubscriber)sub);
        } else if (additionClass.equals(PostCreateShopRelicSubscriber.class)) {
            postCreateShopRelicSubscribers.add((PostCreateShopRelicSubscriber)sub);
        } else if (additionClass.equals(PostCreateShopPotionSubscriber.class)) {
            postCreateShopPotionSubscribers.add((PostCreateShopPotionSubscriber)sub);
        } else if (additionClass.equals(EditCardsSubscriber.class)) {
            editCardsSubscribers.add((EditCardsSubscriber)sub);
        } else if (additionClass.equals(EditRelicsSubscriber.class)) {
            editRelicsSubscribers.add((EditRelicsSubscriber)sub);
        } else if (additionClass.equals(EditCharactersSubscriber.class)) {
            editCharactersSubscribers.add((EditCharactersSubscriber)sub);
        } else if (additionClass.equals(EditStringsSubscriber.class)) {
            editStringsSubscribers.add((EditStringsSubscriber)sub);
        } else if (additionClass.equals(EditKeywordsSubscriber.class)) {
            editKeywordsSubscribers.add((EditKeywordsSubscriber)sub);
        } else if (additionClass.equals(PostBattleSubscriber.class)) {
            postBattleSubscribers.add((PostBattleSubscriber)sub);
        } else if (additionClass.equals(SetUnlocksSubscriber.class)) {
            setUnlocksSubscribers.add((SetUnlocksSubscriber)sub);
        } else if (additionClass.equals(PostPotionUseSubscriber.class)) {
            postPotionUseSubscribers.add((PostPotionUseSubscriber)sub);
        } else if (additionClass.equals(PrePotionUseSubscriber.class)) {
            prePotionUseSubscribers.add((PrePotionUseSubscriber)sub);
        } else if (additionClass.equals(PotionGetSubscriber.class)) {
            potionGetSubscribers.add((PotionGetSubscriber)sub);
        } else if (additionClass.equals(RelicGetSubscriber.class)) {
            relicGetSubscribers.add((RelicGetSubscriber)sub);
        } else if (additionClass.equals(PostPowerApplySubscriber.class)) {
            postPowerApplySubscribers.add((PostPowerApplySubscriber)sub);
        } else if (additionClass.equals(OnPowersModifiedSubscriber.class)) {
            onPowersModifiedSubscribers.add((OnPowersModifiedSubscriber)sub);
        } else if (additionClass.equals(PostDeathSubscriber.class)) {
            postDeathSubscribers.add((PostDeathSubscriber)sub);
        } else if (additionClass.equals(OnStartBattleSubscriber.class)) {
            startBattleSubscribers.add((OnStartBattleSubscriber)sub);
        } else if (additionClass.equals(AddCustomModeModsSubscriber.class)) {
            addCustomModeModsSubscribers.add((AddCustomModeModsSubscriber)sub);
        } else if (additionClass.equals(MaxHPChangeSubscriber.class)) {
            maxHPChangeSubscribers.add((MaxHPChangeSubscriber)sub);
        } else if (additionClass.equals(PreRoomRenderSubscriber.class)) {
            preRoomRenderSubscribers.add((PreRoomRenderSubscriber)sub);
        } else if (additionClass.equals(OnPlayerLoseBlockSubscriber.class)) {
            onPlayerLoseBlockSubscribers.add((OnPlayerLoseBlockSubscriber)sub);
        } else if (additionClass.equals(OnPlayerDamagedSubscriber.class)) {
            onPlayerDamagedSubscribers.add((OnPlayerDamagedSubscriber)sub);
        } else if (additionClass.equals(OnCreateDescriptionSubscriber.class)) {
            onCreateDescriptionSubscribers.add((OnCreateDescriptionSubscriber)sub);
        }
    }

    public static void unsubscribe(ISubscriber sub) {
        BaseMod.unsubscribeIfInstance(startActSubscribers, sub, StartActSubscriber.class);
        BaseMod.unsubscribeIfInstance(postCampfireSubscribers, sub, PostCampfireSubscriber.class);
        BaseMod.unsubscribeIfInstance(postDrawSubscribers, sub, PostDrawSubscriber.class);
        BaseMod.unsubscribeIfInstance(postExhaustSubscribers, sub, PostExhaustSubscriber.class);
        BaseMod.unsubscribeIfInstance(onCardUseSubscribers, sub, OnCardUseSubscriber.class);
        BaseMod.unsubscribeIfInstance(postDungeonInitializeSubscribers, sub, PostDungeonInitializeSubscriber.class);
        BaseMod.unsubscribeIfInstance(postEnergyRechargeSubscribers, sub, PostEnergyRechargeSubscriber.class);
        BaseMod.unsubscribeIfInstance(postInitializeSubscribers, sub, PostInitializeSubscriber.class);
        BaseMod.unsubscribeIfInstance(preMonsterTurnSubscribers, sub, PreMonsterTurnSubscriber.class);
        BaseMod.unsubscribeIfInstance(renderSubscribers, sub, RenderSubscriber.class);
        BaseMod.unsubscribeIfInstance(preRenderSubscribers, sub, PreRenderSubscriber.class);
        BaseMod.unsubscribeIfInstance(postRenderSubscribers, sub, PostRenderSubscriber.class);
        BaseMod.unsubscribeIfInstance(modelRenderSubscribers, sub, ModelRenderSubscriber.class);
        BaseMod.unsubscribeIfInstance(preStartGameSubscribers, sub, PreStartGameSubscriber.class);
        BaseMod.unsubscribeIfInstance(startGameSubscribers, sub, StartGameSubscriber.class);
        BaseMod.unsubscribeIfInstance(preUpdateSubscribers, sub, PreUpdateSubscriber.class);
        BaseMod.unsubscribeIfInstance(postUpdateSubscribers, sub, PostUpdateSubscriber.class);
        BaseMod.unsubscribeIfInstance(postDungeonUpdateSubscribers, sub, PostDungeonUpdateSubscriber.class);
        BaseMod.unsubscribeIfInstance(preDungeonUpdateSubscribers, sub, PreDungeonUpdateSubscriber.class);
        BaseMod.unsubscribeIfInstance(postPlayerUpdateSubscribers, sub, PostPlayerUpdateSubscriber.class);
        BaseMod.unsubscribeIfInstance(prePlayerUpdateSubscribers, sub, PrePlayerUpdateSubscriber.class);
        BaseMod.unsubscribeIfInstance(postCreateStartingDeckSubscribers, sub, PostCreateStartingDeckSubscriber.class);
        BaseMod.unsubscribeIfInstance(postCreateStartingRelicsSubscribers, sub, PostCreateStartingRelicsSubscriber.class);
        BaseMod.unsubscribeIfInstance(postCreateShopRelicSubscribers, sub, PostCreateShopRelicSubscriber.class);
        BaseMod.unsubscribeIfInstance(postCreateShopPotionSubscribers, sub, PostCreateShopPotionSubscriber.class);
        BaseMod.unsubscribeIfInstance(editCardsSubscribers, sub, EditCardsSubscriber.class);
        BaseMod.unsubscribeIfInstance(editRelicsSubscribers, sub, EditRelicsSubscriber.class);
        BaseMod.unsubscribeIfInstance(editCharactersSubscribers, sub, EditCharactersSubscriber.class);
        BaseMod.unsubscribeIfInstance(editStringsSubscribers, sub, EditStringsSubscriber.class);
        BaseMod.unsubscribeIfInstance(editKeywordsSubscribers, sub, EditKeywordsSubscriber.class);
        BaseMod.unsubscribeIfInstance(postBattleSubscribers, sub, PostBattleSubscriber.class);
        BaseMod.unsubscribeIfInstance(setUnlocksSubscribers, sub, SetUnlocksSubscriber.class);
        BaseMod.unsubscribeIfInstance(postPotionUseSubscribers, sub, PostPotionUseSubscriber.class);
        BaseMod.unsubscribeIfInstance(prePotionUseSubscribers, sub, PrePotionUseSubscriber.class);
        BaseMod.unsubscribeIfInstance(potionGetSubscribers, sub, PotionGetSubscriber.class);
        BaseMod.unsubscribeIfInstance(relicGetSubscribers, sub, RelicGetSubscriber.class);
        BaseMod.unsubscribeIfInstance(postPowerApplySubscribers, sub, PostPowerApplySubscriber.class);
        BaseMod.unsubscribeIfInstance(onPowersModifiedSubscribers, sub, OnPowersModifiedSubscriber.class);
        BaseMod.unsubscribeIfInstance(postDeathSubscribers, sub, PostDeathSubscriber.class);
        BaseMod.unsubscribeIfInstance(startBattleSubscribers, sub, OnStartBattleSubscriber.class);
        BaseMod.unsubscribeIfInstance(addCustomModeModsSubscribers, sub, AddCustomModeModsSubscriber.class);
        BaseMod.unsubscribeIfInstance(maxHPChangeSubscribers, sub, MaxHPChangeSubscriber.class);
        BaseMod.unsubscribeIfInstance(preRoomRenderSubscribers, sub, PreRoomRenderSubscriber.class);
        BaseMod.unsubscribeIfInstance(onPlayerLoseBlockSubscribers, sub, OnPlayerLoseBlockSubscriber.class);
        BaseMod.unsubscribeIfInstance(onPlayerDamagedSubscribers, sub, OnPlayerDamagedSubscriber.class);
        BaseMod.unsubscribeIfInstance(onCreateDescriptionSubscribers, sub, OnCreateDescriptionSubscriber.class);
    }

    public static void unsubscribe(ISubscriber sub, Class<? extends ISubscriber> removalClass) {
        if (removalClass.equals(StartActSubscriber.class)) {
            startActSubscribers.remove(sub);
        } else if (removalClass.equals(PostCampfireSubscriber.class)) {
            postCampfireSubscribers.remove(sub);
        } else if (removalClass.equals(PostDrawSubscriber.class)) {
            postDrawSubscribers.remove(sub);
        } else if (removalClass.equals(PostExhaustSubscriber.class)) {
            postExhaustSubscribers.remove(sub);
        } else if (removalClass.equals(OnCardUseSubscriber.class)) {
            onCardUseSubscribers.remove(sub);
        } else if (removalClass.equals(PostDungeonInitializeSubscriber.class)) {
            postDungeonInitializeSubscribers.remove(sub);
        } else if (removalClass.equals(PostEnergyRechargeSubscriber.class)) {
            postEnergyRechargeSubscribers.remove(sub);
        } else if (removalClass.equals(PostInitializeSubscriber.class)) {
            postInitializeSubscribers.remove(sub);
        } else if (removalClass.equals(PreMonsterTurnSubscriber.class)) {
            preMonsterTurnSubscribers.remove(sub);
        } else if (removalClass.equals(RenderSubscriber.class)) {
            renderSubscribers.remove(sub);
        } else if (removalClass.equals(PreRenderSubscriber.class)) {
            preRenderSubscribers.remove(sub);
        } else if (removalClass.equals(PostRenderSubscriber.class)) {
            postRenderSubscribers.remove(sub);
        } else if (removalClass.equals(ModelRenderSubscriber.class)) {
            modelRenderSubscribers.remove(sub);
        } else if (removalClass.equals(PreStartGameSubscriber.class)) {
            preStartGameSubscribers.remove(sub);
        } else if (removalClass.equals(StartGameSubscriber.class)) {
            startGameSubscribers.remove(sub);
        } else if (removalClass.equals(PreUpdateSubscriber.class)) {
            preUpdateSubscribers.remove(sub);
        } else if (removalClass.equals(PostUpdateSubscriber.class)) {
            postUpdateSubscribers.remove(sub);
        } else if (removalClass.equals(PostDungeonUpdateSubscriber.class)) {
            postDungeonUpdateSubscribers.remove(sub);
        } else if (removalClass.equals(PreDungeonUpdateSubscriber.class)) {
            preDungeonUpdateSubscribers.remove(sub);
        } else if (removalClass.equals(PostPlayerUpdateSubscriber.class)) {
            postPlayerUpdateSubscribers.remove(sub);
        } else if (removalClass.equals(PrePlayerUpdateSubscriber.class)) {
            prePlayerUpdateSubscribers.remove(sub);
        } else if (removalClass.equals(PostCreateStartingDeckSubscriber.class)) {
            postCreateStartingDeckSubscribers.remove(sub);
        } else if (removalClass.equals(PostCreateStartingRelicsSubscriber.class)) {
            postCreateStartingRelicsSubscribers.remove(sub);
        } else if (removalClass.equals(PostCreateShopRelicSubscriber.class)) {
            postCreateShopRelicSubscribers.remove(sub);
        } else if (removalClass.equals(PostCreateShopPotionSubscriber.class)) {
            postCreateShopPotionSubscribers.remove(sub);
        } else if (removalClass.equals(EditCardsSubscriber.class)) {
            editCardsSubscribers.remove(sub);
        } else if (removalClass.equals(EditRelicsSubscriber.class)) {
            editRelicsSubscribers.remove(sub);
        } else if (removalClass.equals(EditCharactersSubscriber.class)) {
            editCharactersSubscribers.remove(sub);
        } else if (removalClass.equals(EditStringsSubscriber.class)) {
            editStringsSubscribers.remove(sub);
        } else if (removalClass.equals(EditKeywordsSubscriber.class)) {
            editKeywordsSubscribers.remove(sub);
        } else if (removalClass.equals(AddAudioSubscriber.class)) {
            addAudioSubscribers.remove(sub);
        } else if (removalClass.equals(PostBattleSubscriber.class)) {
            postBattleSubscribers.remove(sub);
        } else if (removalClass.equals(SetUnlocksSubscriber.class)) {
            setUnlocksSubscribers.remove(sub);
        } else if (removalClass.equals(PostPotionUseSubscriber.class)) {
            postPotionUseSubscribers.remove(sub);
        } else if (removalClass.equals(PrePotionUseSubscriber.class)) {
            prePotionUseSubscribers.remove(sub);
        } else if (removalClass.equals(PotionGetSubscriber.class)) {
            potionGetSubscribers.remove(sub);
        } else if (removalClass.equals(RelicGetSubscriber.class)) {
            relicGetSubscribers.remove(sub);
        } else if (removalClass.equals(PostPowerApplySubscriber.class)) {
            postPowerApplySubscribers.remove(sub);
        } else if (removalClass.equals(OnPowersModifiedSubscriber.class)) {
            onPowersModifiedSubscribers.remove(sub);
        } else if (removalClass.equals(PostDeathSubscriber.class)) {
            postDeathSubscribers.remove(sub);
        } else if (removalClass.equals(OnStartBattleSubscriber.class)) {
            startBattleSubscribers.remove(sub);
        } else if (removalClass.equals(AddCustomModeModsSubscriber.class)) {
            addCustomModeModsSubscribers.remove(sub);
        } else if (removalClass.equals(MaxHPChangeSubscriber.class)) {
            maxHPChangeSubscribers.remove(sub);
        } else if (removalClass.equals(PreRoomRenderSubscriber.class)) {
            preRoomRenderSubscribers.remove(sub);
        } else if (removalClass.equals(OnPlayerLoseBlockSubscriber.class)) {
            onPlayerLoseBlockSubscribers.remove(sub);
        } else if (removalClass.equals(OnPlayerDamagedSubscriber.class)) {
            onPlayerDamagedSubscribers.remove(sub);
        } else if (removalClass.equals(OnCreateDescriptionSubscriber.class)) {
            onCreateDescriptionSubscribers.remove(sub);
        }
    }

    public static void unsubscribeLater(ISubscriber sub) {
        toRemove.add(sub);
    }

    public static String convertToModID(String id) {
        String modName = BaseMod.findCallingModName();
        return BaseMod.convertToModID(modName, id);
    }

    public static String convertToModID(String modID, String id) {
        if (modID == null && (id.startsWith("slaythespire:") || id.startsWith("sts:") || id.startsWith(":"))) {
            return id.substring(id.indexOf(58) + 1);
        }
        if (modID != null && !id.startsWith(modID + ":")) {
            id = modID + ":" + id;
        }
        return id;
    }

    public static boolean hasModID(String id) {
        for (ModInfo info : Loader.MODINFOS) {
            String modID = null;
            modID = info.ID != null && !info.ID.isEmpty() ? info.ID : info.Name;
            if (!id.startsWith(modID + ":")) continue;
            return true;
        }
        return false;
    }

    public static String findCallingModName() {
        return null;
    }

    public static void openCustomGridScreen(CardGroup group, int numCards, String tipMsg, GridCardSelectScreenFields.GridCallback callback) {
        logger.debug("Opening custom grid screen");
        String gridCancelText = CardCrawlGame.languagePack.getUIString((String)"CardRewardScreen").TEXT[0];
        AbstractDungeon.gridSelectScreen.open(group, numCards, tipMsg, false);
        AbstractDungeon.overlayMenu.cancelButton.show(gridCancelText);
        AbstractDungeon.dynamicBanner.hide();
        GridCardSelectScreenFields.forCustomReward.set((Object)AbstractDungeon.gridSelectScreen, (Object)true);
        GridCardSelectScreenFields.customCallback.set((Object)AbstractDungeon.gridSelectScreen, (Object)callback);
    }

    static {
        lastBaseCharacterIndex = -1;
        cardDynamicVariableMap = new HashMap();
        customSaveFields = new HashMap();
        save_path = "saves" + File.separator;
        modSettingsUp = false;
        mapPathDensityMultiplier = 1.0f;
        modalChoiceScreen = new ModalChoiceScreen();
        customRewardOnLoadConsumers = new HashMap();
        customRewardOnSaveConsumers = new HashMap();
        customMonsterNames = new HashMap();
        customMonsters = new HashMap();
        customMonsterEncounters = new HashMap();
        customStrongMonsterEncounters = new HashMap();
        customEliteEncounters = new HashMap();
        customBosses = new HashMap();
    }

    public static class BossInfo {
        public final String id;
        private final String bossMap;
        private final String bossMapOutline;

        private BossInfo(String id, String mapIcon, String mapIconOutline) {
            this.id = id;
            this.bossMap = mapIcon;
            this.bossMapOutline = mapIconOutline;
        }

        public Texture loadBossMap() {
            return ImageMaster.loadImage((String)this.bossMap);
        }

        public Texture loadBossMapOutline() {
            return ImageMaster.loadImage((String)this.bossMapOutline);
        }
    }

    public static interface GetMonster {
        public AbstractMonster get();
    }

    public static interface GetMonsterGroup {
        public MonsterGroup get();
    }

    public static interface SaveCustomReward {
        public RewardSave onSave(CustomReward var1);
    }

    public static interface LoadCustomReward {
        public CustomReward onLoad(RewardSave var1);
    }
}

