/*
 * Decompiled with CFR 0.152.
 */
package communicationmod;

public class InvalidCommandException
extends Exception {
    private String[] command;
    private InvalidCommandFormat format;
    private String message = "";

    public InvalidCommandException(String[] command, InvalidCommandFormat format, String message) {
        this.command = command;
        this.format = format;
        this.message = message;
    }

    public InvalidCommandException(String[] command, InvalidCommandFormat format) {
        this.command = command;
        this.format = format;
    }

    public InvalidCommandException(String message) {
        this.message = message;
        this.format = InvalidCommandFormat.SIMPLE;
        this.command = new String[1];
        this.command[0] = "";
    }

    @Override
    public String getMessage() {
        String wholeCommand = String.join((CharSequence)" ", this.command);
        switch (this.format) {
            case OUT_OF_BOUNDS: {
                return String.format("Index %s out of bounds in command \"%s\"", this.message, wholeCommand);
            }
            case MISSING_ARGUMENT: {
                return String.format("Argument missing in command \"%s\".%s", wholeCommand, this.message);
            }
            case INVALID_ARGUMENT: {
                return String.format("Invalid argument %s in command \"%s\".", this.message, wholeCommand);
            }
        }
        return this.message;
    }

    public static enum InvalidCommandFormat {
        OUT_OF_BOUNDS,
        MISSING_ARGUMENT,
        INVALID_ARGUMENT,
        SIMPLE;

    }
}

