/*
 * Decompiled with CFR 0.152.
 */
package communicationmod;

import com.megacrit.cardcrawl.actions.GameActionManager;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.neow.NeowRoom;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import com.megacrit.cardcrawl.rooms.EventRoom;
import com.megacrit.cardcrawl.rooms.VictoryRoom;
import communicationmod.CommandExecutor;

public class GameStateListener {
    private static AbstractDungeon.CurrentScreen previousScreen = null;
    private static boolean previousScreenUp = false;
    private static AbstractRoom.RoomPhase previousPhase = null;
    private static int previousGold = 99;
    private static boolean externalChange = false;
    private static boolean myTurn = false;
    private static boolean blocked = false;
    private static boolean waitingForCommand = false;
    private static boolean hasPresentedOutOfGameState = false;
    private static boolean waitOneUpdate = false;
    private static int timeout = 0;

    public static void registerStateChange() {
        externalChange = true;
        waitingForCommand = false;
    }

    public static void setTimeout(int newTimeout) {
        timeout = newTimeout;
    }

    public static void registerCommandExecution() {
        waitingForCommand = false;
    }

    public static void blockStateUpdate() {
        blocked = true;
    }

    public static void resumeStateUpdate() {
        blocked = false;
    }

    public static void signalTurnStart() {
        myTurn = true;
    }

    public static void signalTurnEnd() {
        myTurn = false;
    }

    public static void resetStateVariables() {
        previousScreen = null;
        previousScreenUp = false;
        previousPhase = null;
        previousGold = 99;
        externalChange = false;
        myTurn = false;
        blocked = false;
        waitingForCommand = false;
        waitOneUpdate = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean hasDungeonStateChanged() {
        boolean inCombat;
        if (blocked) {
            return false;
        }
        hasPresentedOutOfGameState = false;
        AbstractDungeon.CurrentScreen newScreen = AbstractDungeon.screen;
        boolean newScreenUp = AbstractDungeon.isScreenUp;
        AbstractRoom.RoomPhase newPhase = AbstractDungeon.getCurrRoom().phase;
        boolean bl = inCombat = newPhase == AbstractRoom.RoomPhase.COMBAT;
        if (AbstractDungeon.isFadingOut || AbstractDungeon.isFadingIn) {
            return false;
        }
        if (newScreen == AbstractDungeon.CurrentScreen.DEATH && newScreen != previousScreen) {
            return true;
        }
        if (newScreen == AbstractDungeon.CurrentScreen.DOOR_UNLOCK || newScreen == AbstractDungeon.CurrentScreen.NO_INTERACT) {
            return false;
        }
        if (inCombat && (!myTurn || AbstractDungeon.getMonsters().areMonstersBasicallyDead()) && !newScreenUp) {
            return false;
        }
        AbstractRoom currentRoom = AbstractDungeon.getCurrRoom();
        if ((currentRoom instanceof EventRoom || currentRoom instanceof NeowRoom || currentRoom instanceof VictoryRoom && ((VictoryRoom)currentRoom).eType == VictoryRoom.EventType.HEART) && AbstractDungeon.getCurrRoom().event.waitTimer != 0.0f) {
            return false;
        }
        if (newScreen != previousScreen || newScreenUp != previousScreenUp || newPhase != previousPhase) {
            if (!inCombat) {
                waitOneUpdate = true;
                previousScreenUp = newScreenUp;
                previousScreen = newScreen;
                previousPhase = newPhase;
                return false;
            }
            if (newScreenUp) {
                return true;
            }
            if (AbstractDungeon.actionManager.phase.equals((Object)GameActionManager.Phase.WAITING_ON_USER) && AbstractDungeon.actionManager.cardQueue.isEmpty() && AbstractDungeon.actionManager.actions.isEmpty()) {
                return true;
            }
        } else if (waitOneUpdate) {
            waitOneUpdate = false;
            return true;
        }
        if (inCombat && AbstractDungeon.player.endTurnQueued) {
            return false;
        }
        if ((externalChange || previousGold != AbstractDungeon.player.gold) && AbstractDungeon.actionManager.phase.equals((Object)GameActionManager.Phase.WAITING_ON_USER) && AbstractDungeon.actionManager.preTurnActions.isEmpty() && AbstractDungeon.actionManager.actions.isEmpty() && AbstractDungeon.actionManager.cardQueue.isEmpty()) {
            return true;
        }
        if (externalChange && inCombat && newScreenUp) {
            return true;
        }
        return timeout > 0 && --timeout == 0;
    }

    public static boolean checkForMenuStateChange() {
        boolean stateChange = false;
        if (!hasPresentedOutOfGameState && CardCrawlGame.mode == CardCrawlGame.GameMode.CHAR_SELECT && CardCrawlGame.mainMenuScreen != null) {
            stateChange = true;
            hasPresentedOutOfGameState = true;
        }
        if (stateChange) {
            externalChange = false;
            waitingForCommand = true;
        }
        return stateChange;
    }

    public static boolean checkForDungeonStateChange() {
        boolean stateChange = false;
        if (CommandExecutor.isInDungeon()) {
            stateChange = GameStateListener.hasDungeonStateChanged();
            if (stateChange) {
                externalChange = false;
                waitingForCommand = true;
                previousPhase = AbstractDungeon.getCurrRoom().phase;
                previousScreen = AbstractDungeon.screen;
                previousScreenUp = AbstractDungeon.isScreenUp;
                previousGold = AbstractDungeon.player.gold;
                timeout = 0;
            }
        } else {
            myTurn = false;
        }
        return stateChange;
    }

    public static boolean isWaitingForCommand() {
        return waitingForCommand;
    }
}

