/*
 * Decompiled with CFR 0.152.
 */
package communicationmod;

import basemod.ReflectionHacks;
import com.autoplay.gson.Gson;
import com.megacrit.cardcrawl.actions.GameActionManager;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.map.MapEdge;
import com.megacrit.cardcrawl.map.MapRoomNode;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.monsters.EnemyMoveInfo;
import com.megacrit.cardcrawl.neow.NeowEvent;
import com.megacrit.cardcrawl.orbs.AbstractOrb;
import com.megacrit.cardcrawl.potions.AbstractPotion;
import com.megacrit.cardcrawl.potions.PotionSlot;
import com.megacrit.cardcrawl.powers.AbstractPower;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.rewards.RewardItem;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import com.megacrit.cardcrawl.rooms.RestRoom;
import com.megacrit.cardcrawl.rooms.TreasureRoom;
import com.megacrit.cardcrawl.rooms.TreasureRoomBoss;
import com.megacrit.cardcrawl.screens.GameOverScreen;
import com.megacrit.cardcrawl.screens.select.GridCardSelectScreen;
import com.megacrit.cardcrawl.shop.ShopScreen;
import com.megacrit.cardcrawl.shop.StorePotion;
import com.megacrit.cardcrawl.shop.StoreRelic;
import com.megacrit.cardcrawl.ui.buttons.LargeDialogOptionButton;
import com.megacrit.cardcrawl.ui.panels.EnergyPanel;
import communicationmod.ChoiceScreenUtils;
import communicationmod.CommandExecutor;
import communicationmod.GameStateListener;
import communicationmod.patches.UpdateBodyTextPatch;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;

public class GameStateConverter {
    public static String getCommunicationState() {
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        response.put("available_commands", CommandExecutor.getAvailableCommands());
        response.put("ready_for_command", Boolean.valueOf(GameStateListener.isWaitingForCommand()));
        boolean isInGame = CommandExecutor.isInDungeon();
        response.put("in_game", Boolean.valueOf(isInGame));
        if (isInGame) {
            response.put("game_state", GameStateConverter.getGameState());
        }
        Gson gson = new Gson();
        return gson.toJson(response);
    }

    private static HashMap<String, Object> getGameState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("screen_name", AbstractDungeon.screen.name());
        state.put("is_screen_up", AbstractDungeon.isScreenUp);
        state.put("screen_type", (Object)ChoiceScreenUtils.getCurrentChoiceType());
        state.put("room_phase", AbstractDungeon.getCurrRoom().phase.toString());
        state.put("action_phase", AbstractDungeon.actionManager.phase.toString());
        if (AbstractDungeon.actionManager.currentAction != null) {
            state.put("current_action", AbstractDungeon.actionManager.currentAction.getClass().getSimpleName());
        }
        state.put("room_type", AbstractDungeon.getCurrRoom().getClass().getSimpleName());
        state.put("current_hp", AbstractDungeon.player.currentHealth);
        state.put("max_hp", AbstractDungeon.player.maxHealth);
        state.put("floor", AbstractDungeon.floorNum);
        state.put("act", AbstractDungeon.actNum);
        state.put("act_boss", AbstractDungeon.bossKey);
        state.put("gold", AbstractDungeon.player.gold);
        state.put("seed", Settings.seed);
        state.put("class", AbstractDungeon.player.chosenClass.name());
        state.put("ascension_level", AbstractDungeon.ascensionLevel);
        ArrayList<HashMap<String, Object>> relics = new ArrayList<HashMap<String, Object>>();
        for (Object relic : AbstractDungeon.player.relics) {
            relics.add(GameStateConverter.convertRelicToJson((AbstractRelic)relic));
        }
        state.put("relics", relics);
        ArrayList<HashMap<String, Object>> deck = new ArrayList<HashMap<String, Object>>();
        for (AbstractCard card : AbstractDungeon.player.masterDeck.group) {
            deck.add(GameStateConverter.convertCardToJson(card));
        }
        state.put("deck", deck);
        ArrayList<HashMap<String, Object>> potions = new ArrayList<HashMap<String, Object>>();
        for (AbstractPotion potion : AbstractDungeon.player.potions) {
            potions.add(GameStateConverter.convertPotionToJson(potion));
        }
        state.put("potions", potions);
        state.put("map", GameStateConverter.convertMapToJson());
        if (CommandExecutor.isChooseCommandAvailable()) {
            state.put("choice_list", ChoiceScreenUtils.getCurrentChoiceList());
        }
        if (AbstractDungeon.getCurrRoom().phase.equals((Object)AbstractRoom.RoomPhase.COMBAT)) {
            state.put("combat_state", GameStateConverter.getCombatState());
        }
        state.put("screen_state", GameStateConverter.getScreenState());
        return state;
    }

    private static HashMap<String, Object> getRoomState() {
        AbstractRoom currentRoom = AbstractDungeon.getCurrRoom();
        HashMap<String, Object> state = new HashMap<String, Object>();
        if (currentRoom instanceof TreasureRoom) {
            state.put("chest_type", ((TreasureRoom)currentRoom).chest.getClass().getSimpleName());
            state.put("chest_open", ((TreasureRoom)currentRoom).chest.isOpen);
        } else if (currentRoom instanceof TreasureRoomBoss) {
            state.put("chest_type", ((TreasureRoomBoss)currentRoom).chest.getClass().getSimpleName());
            state.put("chest_open", ((TreasureRoomBoss)currentRoom).chest.isOpen);
        } else if (currentRoom instanceof RestRoom) {
            state.put("has_rested", currentRoom.phase == AbstractRoom.RoomPhase.COMPLETE);
            state.put("rest_options", ChoiceScreenUtils.getRestRoomChoices());
        }
        return state;
    }

    private static String removeTextFormatting(String text) {
        text = text.replaceAll("~|@(\\S+)~|@", "$1");
        return text.replaceAll("#.|NL", "");
    }

    private static HashMap<String, Object> getEventState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        ArrayList options = new ArrayList();
        ChoiceScreenUtils.EventDialogType eventDialogType = ChoiceScreenUtils.getEventDialogType();
        AbstractEvent event = AbstractDungeon.getCurrRoom().event;
        int choice_index = 0;
        if (eventDialogType == ChoiceScreenUtils.EventDialogType.IMAGE || eventDialogType == ChoiceScreenUtils.EventDialogType.ROOM) {
            for (LargeDialogOptionButton button : ChoiceScreenUtils.getEventButtons()) {
                HashMap<String, Object> json_button = new HashMap<String, Object>();
                json_button.put("text", GameStateConverter.removeTextFormatting(button.msg));
                json_button.put("disabled", button.isDisabled);
                json_button.put("label", ChoiceScreenUtils.getOptionName(button.msg));
                if (!button.isDisabled) {
                    json_button.put("choice_index", choice_index);
                    ++choice_index;
                }
                options.add(json_button);
            }
            state.put("body_text", GameStateConverter.removeTextFormatting(UpdateBodyTextPatch.bodyText));
        } else {
            for (String misc_option : ChoiceScreenUtils.getEventScreenChoices()) {
                HashMap<String, Object> json_button = new HashMap<String, Object>();
                json_button.put("text", misc_option);
                json_button.put("disabled", false);
                json_button.put("label", misc_option);
                json_button.put("choice_index", choice_index);
                ++choice_index;
                options.add(json_button);
            }
            state.put("body_text", "");
        }
        state.put("event_name", ReflectionHacks.getPrivateStatic(event.getClass(), (String)"NAME"));
        if (event instanceof NeowEvent) {
            state.put("event_id", "Neow Event");
        } else {
            try {
                Field targetField = event.getClass().getDeclaredField("ID");
                state.put("event_id", (String)targetField.get(null));
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                state.put("event_id", "");
            }
            state.put("event_id", ReflectionHacks.getPrivateStatic(event.getClass(), (String)"ID"));
        }
        state.put("options", options);
        return state;
    }

    private static HashMap<String, Object> getCardRewardState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("bowl_available", ChoiceScreenUtils.isBowlAvailable());
        state.put("skip_available", ChoiceScreenUtils.isCardRewardSkipAvailable());
        ArrayList<HashMap<String, Object>> cardRewardJson = new ArrayList<HashMap<String, Object>>();
        for (AbstractCard card : AbstractDungeon.cardRewardScreen.rewardGroup) {
            cardRewardJson.add(GameStateConverter.convertCardToJson(card));
        }
        state.put("cards", cardRewardJson);
        return state;
    }

    private static HashMap<String, Object> getCombatRewardState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        ArrayList rewards = new ArrayList();
        for (RewardItem reward : AbstractDungeon.combatRewardScreen.rewards) {
            HashMap<String, Object> jsonReward = new HashMap<String, Object>();
            jsonReward.put("reward_type", reward.type.name());
            switch (reward.type) {
                case GOLD: 
                case STOLEN_GOLD: {
                    jsonReward.put("gold", reward.goldAmt + reward.bonusGold);
                    break;
                }
                case RELIC: {
                    jsonReward.put("relic", GameStateConverter.convertRelicToJson(reward.relic));
                    break;
                }
                case POTION: {
                    jsonReward.put("potion", GameStateConverter.convertPotionToJson(reward.potion));
                    break;
                }
                case SAPPHIRE_KEY: {
                    jsonReward.put("link", GameStateConverter.convertRelicToJson(reward.relicLink.relic));
                }
            }
            rewards.add(jsonReward);
        }
        state.put("rewards", rewards);
        return state;
    }

    private static HashMap<String, Object> getMapScreenState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        if (AbstractDungeon.getCurrMapNode() != null) {
            state.put("current_node", GameStateConverter.convertMapRoomNodeToJson(AbstractDungeon.getCurrMapNode()));
        }
        ArrayList<HashMap<String, Object>> nextNodesJson = new ArrayList<HashMap<String, Object>>();
        for (MapRoomNode node : ChoiceScreenUtils.getMapScreenNodeChoices()) {
            nextNodesJson.add(GameStateConverter.convertMapRoomNodeToJson(node));
        }
        state.put("next_nodes", nextNodesJson);
        state.put("first_node_chosen", AbstractDungeon.firstRoomChosen);
        state.put("boss_available", ChoiceScreenUtils.bossNodeAvailable());
        return state;
    }

    private static HashMap<String, Object> getBossRewardState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> bossRelics = new ArrayList<HashMap<String, Object>>();
        for (AbstractRelic relic : AbstractDungeon.bossRelicScreen.relics) {
            bossRelics.add(GameStateConverter.convertRelicToJson(relic));
        }
        state.put("relics", bossRelics);
        return state;
    }

    private static HashMap<String, Object> getShopScreenState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> shopCards = new ArrayList<HashMap<String, Object>>();
        ArrayList<HashMap<String, Object>> shopRelics = new ArrayList<HashMap<String, Object>>();
        ArrayList<HashMap<String, Object>> shopPotions = new ArrayList<HashMap<String, Object>>();
        for (AbstractCard card : ChoiceScreenUtils.getShopScreenCards()) {
            HashMap<String, Object> jsonCard = GameStateConverter.convertCardToJson(card);
            jsonCard.put("price", card.price);
            shopCards.add(jsonCard);
        }
        for (StoreRelic relic : ChoiceScreenUtils.getShopScreenRelics()) {
            HashMap<String, Object> jsonRelic = GameStateConverter.convertRelicToJson(relic.relic);
            jsonRelic.put("price", relic.price);
            shopRelics.add(jsonRelic);
        }
        for (StorePotion potion : ChoiceScreenUtils.getShopScreenPotions()) {
            HashMap<String, Object> jsonPotion = GameStateConverter.convertPotionToJson(potion.potion);
            jsonPotion.put("price", potion.price);
            shopPotions.add(jsonPotion);
        }
        state.put("cards", shopCards);
        state.put("relics", shopRelics);
        state.put("potions", shopPotions);
        state.put("purge_available", AbstractDungeon.shopScreen.purgeAvailable);
        state.put("purge_cost", ShopScreen.actualPurgeCost);
        return state;
    }

    private static HashMap<String, Object> getGridState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> gridJson = new ArrayList<HashMap<String, Object>>();
        ArrayList<HashMap<String, Object>> gridSelectedJson = new ArrayList<HashMap<String, Object>>();
        ArrayList<AbstractCard> gridCards = ChoiceScreenUtils.getGridScreenCards();
        GridCardSelectScreen screen = AbstractDungeon.gridSelectScreen;
        for (AbstractCard card : gridCards) {
            gridJson.add(GameStateConverter.convertCardToJson(card));
        }
        for (AbstractCard card : screen.selectedCards) {
            gridSelectedJson.add(GameStateConverter.convertCardToJson(card));
        }
        int numCards = (Integer)ReflectionHacks.getPrivate((Object)screen, GridCardSelectScreen.class, (String)"numCards");
        boolean forUpgrade = (Boolean)ReflectionHacks.getPrivate((Object)screen, GridCardSelectScreen.class, (String)"forUpgrade");
        boolean forTransform = (Boolean)ReflectionHacks.getPrivate((Object)screen, GridCardSelectScreen.class, (String)"forTransform");
        boolean forPurge = (Boolean)ReflectionHacks.getPrivate((Object)screen, GridCardSelectScreen.class, (String)"forPurge");
        state.put("cards", gridJson);
        state.put("selected_cards", gridSelectedJson);
        state.put("num_cards", numCards);
        state.put("any_number", screen.anyNumber);
        state.put("for_upgrade", forUpgrade);
        state.put("for_transform", forTransform);
        state.put("for_purge", forPurge);
        state.put("confirm_up", screen.confirmScreenUp || screen.isJustForConfirming);
        return state;
    }

    private static HashMap<String, Object> getHandSelectState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> handJson = new ArrayList<HashMap<String, Object>>();
        ArrayList<HashMap<String, Object>> selectedJson = new ArrayList<HashMap<String, Object>>();
        ArrayList handCards = AbstractDungeon.player.hand.group;
        for (AbstractCard card : handCards) {
            handJson.add(GameStateConverter.convertCardToJson(card));
        }
        state.put("hand", handJson);
        ArrayList selectedCards = AbstractDungeon.handCardSelectScreen.selectedCards.group;
        for (AbstractCard card : selectedCards) {
            selectedJson.add(GameStateConverter.convertCardToJson(card));
        }
        state.put("selected", selectedJson);
        state.put("max_cards", AbstractDungeon.handCardSelectScreen.numCardsToSelect);
        state.put("can_pick_zero", AbstractDungeon.handCardSelectScreen.canPickZero);
        return state;
    }

    private static HashMap<String, Object> getGameOverState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        int score = 0;
        boolean victory = false;
        if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.DEATH) {
            score = (Integer)ReflectionHacks.getPrivate((Object)AbstractDungeon.deathScreen, GameOverScreen.class, (String)"score");
            victory = GameOverScreen.isVictory;
        } else if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.VICTORY) {
            score = (Integer)ReflectionHacks.getPrivate((Object)AbstractDungeon.victoryScreen, GameOverScreen.class, (String)"score");
            victory = true;
        }
        state.put("score", score);
        state.put("victory", victory);
        return state;
    }

    private static HashMap<String, Object> getScreenState() {
        ChoiceScreenUtils.ChoiceType screenType = ChoiceScreenUtils.getCurrentChoiceType();
        switch (screenType) {
            case EVENT: {
                return GameStateConverter.getEventState();
            }
            case CHEST: 
            case REST: {
                return GameStateConverter.getRoomState();
            }
            case CARD_REWARD: {
                return GameStateConverter.getCardRewardState();
            }
            case COMBAT_REWARD: {
                return GameStateConverter.getCombatRewardState();
            }
            case MAP: {
                return GameStateConverter.getMapScreenState();
            }
            case BOSS_REWARD: {
                return GameStateConverter.getBossRewardState();
            }
            case SHOP_SCREEN: {
                return GameStateConverter.getShopScreenState();
            }
            case GRID: {
                return GameStateConverter.getGridState();
            }
            case HAND_SELECT: {
                return GameStateConverter.getHandSelectState();
            }
            case GAME_OVER: {
                return GameStateConverter.getGameOverState();
            }
        }
        return new HashMap<String, Object>();
    }

    private static HashMap<String, Object> getCombatState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> monsters = new ArrayList<HashMap<String, Object>>();
        for (Object monster : AbstractDungeon.getCurrRoom().monsters.monsters) {
            monsters.add(GameStateConverter.convertMonsterToJson((AbstractMonster)monster));
        }
        state.put("monsters", monsters);
        ArrayList<HashMap<String, Object>> draw_pile = new ArrayList<HashMap<String, Object>>();
        for (Object card : AbstractDungeon.player.drawPile.group) {
            draw_pile.add(GameStateConverter.convertCardToJson((AbstractCard)card));
        }
        ArrayList<HashMap<String, Object>> discard_pile = new ArrayList<HashMap<String, Object>>();
        for (Object card : AbstractDungeon.player.discardPile.group) {
            discard_pile.add(GameStateConverter.convertCardToJson((AbstractCard)card));
        }
        ArrayList<HashMap<String, Object>> exhaust_pile = new ArrayList<HashMap<String, Object>>();
        for (Object card : AbstractDungeon.player.exhaustPile.group) {
            exhaust_pile.add(GameStateConverter.convertCardToJson((AbstractCard)card));
        }
        ArrayList<HashMap<String, Object>> hand = new ArrayList<HashMap<String, Object>>();
        for (AbstractCard card : AbstractDungeon.player.hand.group) {
            hand.add(GameStateConverter.convertCardToJson(card));
        }
        ArrayList<HashMap<String, Object>> limbo = new ArrayList<HashMap<String, Object>>();
        for (AbstractCard card : AbstractDungeon.player.limbo.group) {
            limbo.add(GameStateConverter.convertCardToJson(card));
        }
        state.put("draw_pile", draw_pile);
        state.put("discard_pile", discard_pile);
        state.put("exhaust_pile", exhaust_pile);
        state.put("hand", hand);
        state.put("limbo", limbo);
        if (AbstractDungeon.player.cardInUse != null) {
            state.put("card_in_play", GameStateConverter.convertCardToJson(AbstractDungeon.player.cardInUse));
        }
        state.put("player", GameStateConverter.convertPlayerToJson(AbstractDungeon.player));
        state.put("turn", GameActionManager.turn);
        state.put("cards_discarded_this_turn", GameActionManager.totalDiscardedThisTurn);
        state.put("times_damaged", AbstractDungeon.player.damagedThisCombat);
        return state;
    }

    private static ArrayList<Object> convertMapToJson() {
        ArrayList map = AbstractDungeon.map;
        ArrayList<Object> jsonMap = new ArrayList<Object>();
        for (ArrayList layer : map) {
            for (MapRoomNode node : layer) {
                if (!node.hasEdges()) continue;
                HashMap<String, Object> json_node = GameStateConverter.convertMapRoomNodeToJson(node);
                ArrayList<HashMap<String, Object>> json_children = new ArrayList<HashMap<String, Object>>();
                ArrayList<HashMap<String, Object>> json_parents = new ArrayList<HashMap<String, Object>>();
                for (MapEdge edge : node.getEdges()) {
                    if (edge.srcX == node.x && edge.srcY == node.y) {
                        json_children.add(GameStateConverter.convertCoordinatesToJson(edge.dstX, edge.dstY));
                        continue;
                    }
                    json_parents.add(GameStateConverter.convertCoordinatesToJson(edge.srcX, edge.srcY));
                }
                json_node.put("parents", json_parents);
                json_node.put("children", json_children);
                jsonMap.add(json_node);
            }
        }
        return jsonMap;
    }

    private static HashMap<String, Object> convertCoordinatesToJson(int x, int y) {
        HashMap<String, Object> jsonNode = new HashMap<String, Object>();
        jsonNode.put("x", x);
        jsonNode.put("y", y);
        return jsonNode;
    }

    private static HashMap<String, Object> convertMapRoomNodeToJson(MapRoomNode node) {
        HashMap<String, Object> jsonNode = GameStateConverter.convertCoordinatesToJson(node.x, node.y);
        jsonNode.put("symbol", node.getRoomSymbol(Boolean.valueOf(true)));
        return jsonNode;
    }

    private static HashMap<String, Object> convertCardToJson(AbstractCard card) {
        HashMap<String, Object> jsonCard = new HashMap<String, Object>();
        jsonCard.put("name", card.name);
        jsonCard.put("uuid", card.uuid.toString());
        if (card.misc != 0) {
            jsonCard.put("misc", card.misc);
        }
        if (AbstractDungeon.getMonsters() != null) {
            jsonCard.put("is_playable", card.canUse(AbstractDungeon.player, null));
        }
        jsonCard.put("cost", card.costForTurn);
        jsonCard.put("upgrades", card.timesUpgraded);
        jsonCard.put("id", card.cardID);
        jsonCard.put("type", card.type.name());
        jsonCard.put("rarity", card.rarity.name());
        jsonCard.put("has_target", card.target == AbstractCard.CardTarget.SELF_AND_ENEMY || card.target == AbstractCard.CardTarget.ENEMY);
        jsonCard.put("exhausts", card.exhaust);
        jsonCard.put("ethereal", card.isEthereal);
        return jsonCard;
    }

    private static HashMap<String, Object> convertMonsterToJson(AbstractMonster monster) {
        HashMap<String, Object> jsonMonster = new HashMap<String, Object>();
        jsonMonster.put("id", monster.id);
        jsonMonster.put("name", monster.name);
        jsonMonster.put("current_hp", monster.currentHealth);
        jsonMonster.put("max_hp", monster.maxHealth);
        if (AbstractDungeon.player.hasRelic("Runic Dome")) {
            jsonMonster.put("intent", AbstractMonster.Intent.NONE);
        } else {
            jsonMonster.put("intent", monster.intent.name());
            EnemyMoveInfo moveInfo = (EnemyMoveInfo)ReflectionHacks.getPrivate((Object)monster, AbstractMonster.class, (String)"move");
            if (moveInfo != null) {
                jsonMonster.put("move_id", moveInfo.nextMove);
                jsonMonster.put("move_base_damage", moveInfo.baseDamage);
                int intentDmg = (Integer)ReflectionHacks.getPrivate((Object)monster, AbstractMonster.class, (String)"intentDmg");
                if (moveInfo.baseDamage > 0) {
                    jsonMonster.put("move_adjusted_damage", intentDmg);
                } else {
                    jsonMonster.put("move_adjusted_damage", moveInfo.baseDamage);
                }
                int move_hits = moveInfo.multiplier;
                if (!moveInfo.isMultiDamage) {
                    move_hits = 1;
                }
                jsonMonster.put("move_hits", move_hits);
            }
        }
        if (monster.moveHistory.size() >= 2) {
            jsonMonster.put("last_move_id", monster.moveHistory.get(monster.moveHistory.size() - 2));
        }
        if (monster.moveHistory.size() >= 3) {
            jsonMonster.put("second_last_move_id", monster.moveHistory.get(monster.moveHistory.size() - 3));
        }
        jsonMonster.put("half_dead", monster.halfDead);
        jsonMonster.put("is_gone", monster.isDeadOrEscaped());
        jsonMonster.put("block", monster.currentBlock);
        jsonMonster.put("powers", GameStateConverter.convertCreaturePowersToJson((AbstractCreature)monster));
        return jsonMonster;
    }

    private static HashMap<String, Object> convertPlayerToJson(AbstractPlayer player) {
        HashMap<String, Object> jsonPlayer = new HashMap<String, Object>();
        jsonPlayer.put("max_hp", player.maxHealth);
        jsonPlayer.put("current_hp", player.currentHealth);
        jsonPlayer.put("powers", GameStateConverter.convertCreaturePowersToJson((AbstractCreature)player));
        jsonPlayer.put("energy", EnergyPanel.totalCount);
        jsonPlayer.put("block", player.currentBlock);
        ArrayList<HashMap<String, Object>> orbs = new ArrayList<HashMap<String, Object>>();
        for (AbstractOrb orb : player.orbs) {
            orbs.add(GameStateConverter.convertOrbToJson(orb));
        }
        jsonPlayer.put("orbs", orbs);
        return jsonPlayer;
    }

    private static Object getFieldIfExists(Object object, String fieldName) {
        Class<?> objectClass = object.getClass();
        for (Field field : objectClass.getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            try {
                field.setAccessible(true);
                return field.get(object);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private static ArrayList<Object> convertCreaturePowersToJson(AbstractCreature creature) {
        ArrayList<Object> powers = new ArrayList<Object>();
        for (AbstractPower power : creature.powers) {
            Object card;
            HashMap<String, Object> json_power = new HashMap<String, Object>();
            json_power.put("id", power.ID);
            json_power.put("name", power.name);
            json_power.put("amount", power.amount);
            Object damage = GameStateConverter.getFieldIfExists(power, "damage");
            if (damage != null) {
                json_power.put("damage", (Integer)damage);
            }
            if ((card = GameStateConverter.getFieldIfExists(power, "card")) != null) {
                json_power.put("card", GameStateConverter.convertCardToJson((AbstractCard)card));
            }
            String[] miscFieldNames = new String[]{"basePower", "maxAmt", "storedAmount", "hpLoss", "cardsDoubledThisTurn"};
            Object misc = null;
            for (String fieldName : miscFieldNames) {
                misc = GameStateConverter.getFieldIfExists(power, fieldName);
                if (misc == null) continue;
                json_power.put("misc", (Integer)misc);
                break;
            }
            String[] justAppliedNames = new String[]{"justApplied", "skipFirst"};
            Object justApplied = null;
            for (String fieldName : justAppliedNames) {
                justApplied = GameStateConverter.getFieldIfExists(power, fieldName);
                if (justApplied == null) continue;
                json_power.put("just_applied", (Boolean)justApplied);
                break;
            }
            powers.add(json_power);
        }
        return powers;
    }

    private static HashMap<String, Object> convertRelicToJson(AbstractRelic relic) {
        HashMap<String, Object> jsonRelic = new HashMap<String, Object>();
        jsonRelic.put("id", relic.relicId);
        jsonRelic.put("name", relic.name);
        jsonRelic.put("counter", relic.counter);
        return jsonRelic;
    }

    private static HashMap<String, Object> convertPotionToJson(AbstractPotion potion) {
        HashMap<String, Object> jsonPotion = new HashMap<String, Object>();
        jsonPotion.put("id", potion.ID);
        jsonPotion.put("name", potion.name);
        boolean canUse = potion.canUse();
        boolean canDiscard = potion.canDiscard();
        if (potion instanceof PotionSlot) {
            canUse = false;
            canDiscard = false;
        }
        jsonPotion.put("can_use", canUse);
        jsonPotion.put("can_discard", canDiscard);
        jsonPotion.put("requires_target", potion.isThrown);
        return jsonPotion;
    }

    private static HashMap<String, Object> convertOrbToJson(AbstractOrb orb) {
        HashMap<String, Object> jsonOrb = new HashMap<String, Object>();
        jsonOrb.put("id", orb.ID);
        jsonOrb.put("name", orb.name);
        jsonOrb.put("evoke_amount", orb.evokeAmount);
        jsonOrb.put("passive_amount", orb.passiveAmount);
        return jsonOrb;
    }
}

