/*
 * Decompiled with CFR 0.152.
 */
package communicationmod;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.BlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataWriter
implements Runnable {
    private final BlockingQueue<String> queue;
    private final OutputStream stream;
    private boolean verbose;
    private static final Logger logger = LogManager.getLogger((String)DataWriter.class.getName());

    public DataWriter(BlockingQueue<String> queue, OutputStream stream, boolean verbose) {
        this.queue = queue;
        this.stream = stream;
        this.verbose = verbose;
    }

    @Override
    public void run() {
        String message = "";
        while (!Thread.currentThread().isInterrupted()) {
            try {
                message = this.queue.take();
                if (this.verbose) {
                    logger.info("Sending message: " + message);
                }
                this.stream.write(message.getBytes());
                this.stream.write(10);
                this.stream.flush();
            }
            catch (InterruptedException e) {
                logger.info("Communications writing thread interrupted.");
                Thread.currentThread().interrupt();
            }
            catch (IOException e) {
                logger.error("Message could not be sent to child process: " + message);
                e.printStackTrace();
            }
        }
    }
}

