/*
 * Decompiled with CFR 0.152.
 */
package communicationmod;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.BlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataReader
implements Runnable {
    private final BlockingQueue<String> queue;
    private final InputStream stream;
    private static final Logger logger = LogManager.getLogger((String)DataReader.class.getName());
    private boolean verbose;

    public DataReader(BlockingQueue<String> queue, InputStream stream, boolean verbose) {
        this.queue = queue;
        this.stream = stream;
        this.verbose = verbose;
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            StringBuilder inputBuffer = new StringBuilder();
            try {
                while (true) {
                    int nextChar;
                    if ((nextChar = this.stream.read()) == -1) {
                        continue;
                    }
                    if (nextChar == 0 || nextChar == 10) break;
                    inputBuffer.append((char)nextChar);
                }
                if (inputBuffer.length() <= 0) continue;
                if (this.verbose) {
                    logger.info("Received message: " + inputBuffer.toString());
                }
                this.queue.put(inputBuffer.toString());
            }
            catch (IOException e) {
                logger.error("Message could not be received from child process. Shutting down reading thread.");
                Thread.currentThread().interrupt();
            }
            catch (InterruptedException e) {
                logger.info("Communications reading thread interrupted.");
                Thread.currentThread().interrupt();
            }
        }
    }
}

