/*
 * Decompiled with CFR 0.152.
 */
package communicationmod;

import basemod.BaseMod;
import basemod.IUIElement;
import basemod.ModButton;
import basemod.ModLabel;
import basemod.ModLabeledToggleButton;
import basemod.ModPanel;
import basemod.interfaces.ISubscriber;
import basemod.interfaces.PostDungeonUpdateSubscriber;
import basemod.interfaces.PostInitializeSubscriber;
import basemod.interfaces.PostUpdateSubscriber;
import basemod.interfaces.PreUpdateSubscriber;
import com.autoplay.gson.Gson;
import com.badlogic.gdx.graphics.Texture;
import com.evacipated.cardcrawl.modthespire.lib.SpireConfig;
import com.evacipated.cardcrawl.modthespire.lib.SpireInitializer;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import communicationmod.CommandExecutor;
import communicationmod.DataReader;
import communicationmod.DataWriter;
import communicationmod.GameStateConverter;
import communicationmod.GameStateListener;
import communicationmod.InvalidCommandException;
import communicationmod.OnStateChangeSubscriber;
import communicationmod.patches.InputActionPatch;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SpireInitializer
public class CommunicationMod
implements PostInitializeSubscriber,
PostUpdateSubscriber,
PostDungeonUpdateSubscriber,
PreUpdateSubscriber,
OnStateChangeSubscriber {
    private static Process listener;
    private static StringBuilder inputBuffer;
    public static boolean messageReceived;
    private static final Logger logger;
    private static Thread writeThread;
    private static BlockingQueue<String> writeQueue;
    private static Thread readThread;
    private static BlockingQueue<String> readQueue;
    private static final String MODNAME = "Communication Mod";
    private static final String AUTHOR = "Forgotten Arbiter";
    private static final String DESCRIPTION = "This mod communicates with an external program to play Slay the Spire.";
    public static boolean mustSendGameState;
    private static ArrayList<OnStateChangeSubscriber> onStateChangeSubscribers;
    private static SpireConfig communicationConfig;
    private static final String COMMAND_OPTION = "command";
    private static final String GAME_START_OPTION = "runAtGameStart";
    private static final String VERBOSE_OPTION = "verbose";
    private static final String INITIALIZATION_TIMEOUT_OPTION = "maxInitializationTimeout";
    private static final String DEFAULT_COMMAND = "";
    private static final long DEFAULT_TIMEOUT = 10L;
    private static final boolean DEFAULT_VERBOSITY = true;

    public CommunicationMod() {
        BaseMod.subscribe((ISubscriber)this);
        onStateChangeSubscribers = new ArrayList();
        CommunicationMod.subscribe(this);
        readQueue = new LinkedBlockingQueue<String>();
        try {
            Properties defaults = new Properties();
            defaults.put(GAME_START_OPTION, Boolean.toString(false));
            defaults.put(INITIALIZATION_TIMEOUT_OPTION, Long.toString(10L));
            defaults.put(VERBOSE_OPTION, Boolean.toString(true));
            communicationConfig = new SpireConfig("CommunicationMod", "config", defaults);
            String command = communicationConfig.getString(COMMAND_OPTION);
            if (command == null) {
                communicationConfig.setString(COMMAND_OPTION, DEFAULT_COMMAND);
                communicationConfig.save();
            }
            communicationConfig.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (CommunicationMod.getRunOnGameStartOption()) {
            boolean bl = this.startExternalProcess();
        }
    }

    public static void initialize() {
        CommunicationMod mod = new CommunicationMod();
    }

    public void receivePreUpdate() {
        if (listener != null && !listener.isAlive() && writeThread != null && writeThread.isAlive()) {
            logger.info("Child process has died...");
            writeThread.interrupt();
            readThread.interrupt();
        }
        if (CommunicationMod.messageAvailable()) {
            try {
                boolean stateChanged = CommandExecutor.executeCommand(CommunicationMod.readMessage());
                if (stateChanged) {
                    GameStateListener.registerCommandExecution();
                }
            }
            catch (InvalidCommandException e) {
                HashMap<String, Object> jsonError = new HashMap<String, Object>();
                jsonError.put("error", e.getMessage());
                jsonError.put("ready_for_command", GameStateListener.isWaitingForCommand());
                Gson gson = new Gson();
                CommunicationMod.sendMessage(gson.toJson(jsonError));
            }
        }
    }

    public static void subscribe(OnStateChangeSubscriber sub) {
        onStateChangeSubscribers.add(sub);
    }

    public static void publishOnGameStateChange() {
        for (OnStateChangeSubscriber sub : onStateChangeSubscribers) {
            sub.receiveOnStateChange();
        }
    }

    @Override
    public void receiveOnStateChange() {
        CommunicationMod.sendGameState();
    }

    public static void queueCommand(String command) {
        readQueue.add(command);
    }

    public void receivePostInitialize() {
        this.setUpOptionsMenu();
    }

    public void receivePostUpdate() {
        if (!mustSendGameState && GameStateListener.checkForMenuStateChange()) {
            mustSendGameState = true;
        }
        if (mustSendGameState) {
            CommunicationMod.publishOnGameStateChange();
            mustSendGameState = false;
        }
        InputActionPatch.doKeypress = false;
    }

    public void receivePostDungeonUpdate() {
        if (GameStateListener.checkForDungeonStateChange()) {
            mustSendGameState = true;
        }
        if (AbstractDungeon.getCurrRoom().isBattleOver) {
            GameStateListener.signalTurnEnd();
        }
    }

    private void setUpOptionsMenu() {
        ModPanel settingsPanel = new ModPanel();
        ModLabeledToggleButton gameStartOptionButton = new ModLabeledToggleButton("Start external process at game launch", 350.0f, 550.0f, Settings.CREAM_COLOR, FontHelper.charDescFont, CommunicationMod.getRunOnGameStartOption(), settingsPanel, modLabel -> {}, modToggleButton -> {
            if (communicationConfig != null) {
                communicationConfig.setBool(GAME_START_OPTION, modToggleButton.enabled);
                try {
                    communicationConfig.save();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        settingsPanel.addUIElement((IUIElement)gameStartOptionButton);
        ModLabel externalCommandLabel = new ModLabel(DEFAULT_COMMAND, 350.0f, 600.0f, Settings.CREAM_COLOR, FontHelper.charDescFont, settingsPanel, modLabel -> {
            modLabel.text = String.format("External Process Command: %s", CommunicationMod.getSubprocessCommandString());
        });
        settingsPanel.addUIElement((IUIElement)externalCommandLabel);
        ModButton startProcessButton = new ModButton(350.0f, 650.0f, settingsPanel, modButton -> {
            BaseMod.modSettingsUp = false;
            this.startExternalProcess();
        });
        settingsPanel.addUIElement((IUIElement)startProcessButton);
        ModLabel startProcessLabel = new ModLabel("(Re)start external process", 475.0f, 700.0f, Settings.CREAM_COLOR, FontHelper.charDescFont, settingsPanel, modLabel -> {
            modLabel.text = listener != null && listener.isAlive() ? "Restart external process" : "Start external process";
        });
        settingsPanel.addUIElement((IUIElement)startProcessLabel);
        ModButton editProcessButton = new ModButton(850.0f, 650.0f, settingsPanel, modButton -> {});
        settingsPanel.addUIElement((IUIElement)editProcessButton);
        ModLabel editProcessLabel = new ModLabel("Set command (not implemented)", 975.0f, 700.0f, Settings.CREAM_COLOR, FontHelper.charDescFont, settingsPanel, modLabel -> {});
        settingsPanel.addUIElement((IUIElement)editProcessLabel);
        ModLabeledToggleButton verbosityOption = new ModLabeledToggleButton("Suppress verbose log output", 350.0f, 500.0f, Settings.CREAM_COLOR, FontHelper.charDescFont, CommunicationMod.getVerbosityOption(), settingsPanel, modLabel -> {}, modToggleButton -> {
            if (communicationConfig != null) {
                communicationConfig.setBool(VERBOSE_OPTION, modToggleButton.enabled);
                try {
                    communicationConfig.save();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        settingsPanel.addUIElement((IUIElement)verbosityOption);
        BaseMod.registerModBadge((Texture)ImageMaster.loadImage((String)"Icon.png"), (String)MODNAME, (String)AUTHOR, null, (ModPanel)settingsPanel);
    }

    private void startCommunicationThreads() {
        writeQueue = new LinkedBlockingQueue<String>();
        writeThread = new Thread(new DataWriter(writeQueue, listener.getOutputStream(), CommunicationMod.getVerbosityOption()));
        writeThread.start();
        readThread = new Thread(new DataReader(readQueue, listener.getInputStream(), CommunicationMod.getVerbosityOption()));
        readThread.start();
    }

    private static void sendGameState() {
        String state = GameStateConverter.getCommunicationState();
        CommunicationMod.sendMessage(state);
    }

    public static void dispose() {
        logger.info("Shutting down child process...");
        if (listener != null) {
            listener.destroy();
        }
    }

    private static void sendMessage(String message) {
        if (writeQueue != null && writeThread.isAlive()) {
            writeQueue.add(message);
        }
    }

    private static boolean messageAvailable() {
        return readQueue != null && !readQueue.isEmpty();
    }

    private static String readMessage() {
        if (CommunicationMod.messageAvailable()) {
            return (String)readQueue.remove();
        }
        return null;
    }

    private static String readMessageBlocking() {
        try {
            return readQueue.poll(CommunicationMod.getInitializationTimeoutOption(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while trying to read message from subprocess.");
        }
    }

    private static String[] getSubprocessCommand() {
        if (communicationConfig == null) {
            return new String[0];
        }
        return communicationConfig.getString(COMMAND_OPTION).trim().split("\\s+");
    }

    private static String getSubprocessCommandString() {
        if (communicationConfig == null) {
            return DEFAULT_COMMAND;
        }
        return communicationConfig.getString(COMMAND_OPTION).trim();
    }

    private static boolean getRunOnGameStartOption() {
        if (communicationConfig == null) {
            return false;
        }
        return communicationConfig.getBool(GAME_START_OPTION);
    }

    private static long getInitializationTimeoutOption() {
        if (communicationConfig == null) {
            return 10L;
        }
        return communicationConfig.getInt(INITIALIZATION_TIMEOUT_OPTION);
    }

    private static boolean getVerbosityOption() {
        if (communicationConfig == null) {
            return true;
        }
        return communicationConfig.getBool(VERBOSE_OPTION);
    }

    private boolean startExternalProcess() {
        if (readThread != null) {
            readThread.interrupt();
        }
        if (writeThread != null) {
            writeThread.interrupt();
        }
        if (listener != null) {
            listener.destroy();
            try {
                boolean success = listener.waitFor(2L, TimeUnit.SECONDS);
                if (!success) {
                    listener.destroyForcibly();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                listener.destroyForcibly();
            }
        }
        ProcessBuilder builder = new ProcessBuilder(CommunicationMod.getSubprocessCommand());
        File errorLog = new File("communication_mod_errors.log");
        builder.redirectError(ProcessBuilder.Redirect.appendTo(errorLog));
        try {
            listener = builder.start();
        }
        catch (IOException e) {
            logger.error("Could not start external process.");
            e.printStackTrace();
        }
        if (listener != null) {
            this.startCommunicationThreads();
            String message = CommunicationMod.readMessageBlocking();
            if (message == null) {
                readThread.interrupt();
                writeThread.interrupt();
                listener.destroy();
                logger.error("Timed out while waiting for signal from external process.");
                logger.error("Check communication_mod_errors.log for stderr from the process.");
                return false;
            }
            logger.info(String.format("Received message from external process: %s", message));
            if (GameStateListener.isWaitingForCommand()) {
                mustSendGameState = true;
            }
            return true;
        }
        return false;
    }

    static {
        inputBuffer = new StringBuilder();
        messageReceived = false;
        logger = LogManager.getLogger((String)CommunicationMod.class.getName());
        mustSendGameState = false;
    }
}

