#!/bin/bash

# Weather script by Storm dragon
# This uses the Yahoo! weather API.
# Released under the terms of the WTFPL: http://wtfpl.net

get_xdg_path()
{
xdgPath="${XDG_CONFIG_HOME:-$HOME/.config/}"
xdgPath="${xdgPath}weather-script/"
configPath="${xdgPath}config"
if ! [ -d "$xdgPath" ]; then
mkdir -p "$xdgPath"
fi
}

die()
{
    >&2 echo "$1" | fold -s
    if [[ "$2" =~ ^[0-9]+$ ]]; then
        if [ $2 -le 255 ]; then
            exit $2
        fi
    fi
        exit 1
}

show()
{
echo "$@" | fold -s
if [ -x /usr/bin/xclip ]; then
echo "$@" | fold -s | xclip -selection clipboard 2> /dev/null
fi
}

get_zipcode()
{
if [ -r "$configPath" ]; then
source "$configPath"
else
zipcode="$(curl -s "http://ipinfo.io" | grep '"postal":' | tr -cd "[:digit:]")"
if [ -z "$zipcode" ]; then
die "Missing zipcode information. Please edit $HOME/.config/weather-script/config and add the line zipcode=yourcode"
else
echo -e "unit=f\nzipcode=$zipcode" > "$configPath"
fi
fi
unit="${unit:-f}"
}

get_xdg_path
get_zipcode
info="$(elinks -dump "http://weather.yahooapis.com/forecastrss?p=${zipcode}&u=$unit")"
location="$(echo "$info" | grep "Yahoo! Weather for " | sed -e 's/Yahoo! Weather for //' -e 's/^ *//' | cut -d , -f1)"
weather="$(echo "$info" | grep -A 2 "Current Conditions:" | grep -v "Current Conditions:")"
temperature="$(echo "$weather" | cut -d , -f2 | tr -d "[:space:]" | sed -e 's/F/ degrees fahrenheit/' -e 's/C/ degrees Celsius/')"
condition="$(echo "$weather" | sed 's/^ *//' | cut -d , -f1)"
update="$(echo "$info" | grep -B 1 "Current Conditions:" | grep -v "Current Conditions:")"
if ! [ "$location" ]; then
die "Sorry, your location was not found. Try changing the postal code in $HOME/.config/weather-script/config" 255
else
show "It is $temperature and ${condition,} in $location. Last updated $update."
fi
exit 0
