#!/bin/bash
# this presents the weather
# change the city to yours (see manual)
# for this you need weather-util
# in Arch the AUR package is called weather
# in Debian, Mint and Ubuntu its called weather-util
# this is the default of the software

# This script should automaticaly detect your city. If it does not...
# Add your city name on the next line between the quotes.
city="Yonkers"
scriptPath="$(readlink -f $0)"
if [ "$city" = "" ]; then
city="$(curl -s http://ipinfo.io | grep '"city"' | cut -d '"' -f4)"
sed -i "s/^city=\"\"$/city=\"$city\"/" "$scriptPath"
fi
if [ "$city" = "" ]; then
echo "Please set your city name in $scriptPath"
exit 0
fi
if [ -x /usr/bin/weather ]; then
    weatherCommand="weather"
elif [ -x /usr/bin/weather-report ]; then
    weatherCommand="weather-report"
else
    echo "${0##*/} requires weather-util, called weather in Arch Linux. Please install the missing package and try again."
fi
weatherInfo="$($weatherCommand "$city" | tail -n +5)"
echo "$weatherInfo" | sed -e 's/Temperature:/It is/' -e 's/ F / degrees fahrenheit /' -e "s/C)/degrees celsius) in $city./" -e 's/MPH/miles per hour/g' -e 's/KT/knots/g' -e 's/Windchill\(.*\) in .*/Windchill\1/' | tr "[:space:]" " " | tr -s "[:space:]" | fold -s
if [ -x /usr/bin/xclip ]; then
echo "$weatherInfo" | sed -e 's/Temperature:/It is/' -e 's/ F / degrees fahrenheit /' -e "s/C)/degrees celsius) in $city./" -e 's/MPH/miles per hour/g' -e 's/KT/knots/g' -e 's/Windchill\(.*\) in .*/Windchill\1/' | tr "[:space:]" " " | tr -s "[:space:]" | fold -s | xclip -selection clipboard 2> /dev/null
fi
exit 0
