#!/bin/bash

ifs="$IFS"
IFS=$'\n'
winePath="$HOME/.wine/drive_c/Program Files"
unset gamemenu
declare -A gameList
# Alter Aeon
gameName="Alter Aeon"
if [ -x "/usr/bin/tintin-alteraeon" ]; then
if [ -z "$gameMenu" ]; then
gameMenu=($gameName)
else
gameMenu=(${gameMenu[@]}$'\n'$gameName)
fi
gameList[$gameName]="/usr/bin/tintin-alteraeon"
fi

# Audio Disc
gameName="Audio Disc"
if [ -d "$winePath/audiodisc" ]; then
if [ -z "$gameMenu" ]; then
gameMenu=($gameName)
else
gameMenu=(${gameMenu[@]}$'\n'$gameName)
fi
gameList[$gameName]="$winePath/audiodisc/disco.exe"
fi

# Chopper Challenge
gameName="Chopper Challenge"
if [ -d "$winePath/x-sight interactive/chopper challenge" ]; then
if [ -z "$gameMenu" ]; then
gameMenu=($gameName)
else
gameMenu=(${gameMenu[@]}$'\n'$gameName)
fi
gameList[$gameName]="$winePath/x-sight interactive/chopper challenge/Chopper.exe"
fi

# Duck Hunt
gameName="Duck Hunt"
if [ -d "$winePath/Lworks/Duck Hunt" ]; then
if [ -z "$gameMenu" ]; then
gameMenu=($gameName)
else
gameMenu=(${gameMenu[@]}$'\n'$gameName)
fi
gameList[$gameName]="$winePath/Lworks/Duck Hunt/duckhunt.exe"
fi

# Kitchens INC
gameName="Kitchens INC"
if [ -d "$winePath/kitchensinc" ]; then
if [ -z "$gameMenu" ]; then
gameMenu=($gameName)
else
gameMenu=(${gameMenu[@]}$'\n'$gameName)
fi
gameList[$gameName]="$winePath/kitchensinc/gamemenu.exe"
fi

# Palace Punch-up
gameName="Palace Punch-up"
if [ -d "$winePath/Palace Punch-up" ]; then
if [ -z "$gameMenu" ]; then
gameMenu=($gameName)
else
gameMenu=(${gameMenu[@]}$'\n'$gameName)
fi
gameList[$gameName]="$winePath/Palace Punch-up/palace.exe"
fi

# Q9 Action Game
gameName="Q9 Action Game"
if [ -d "$winePath/Q9 Action Game" ]; then
if [ -z "$gameMenu" ]; then
gameMenu=($gameName)
else
gameMenu=(${gameMenu[@]}$'\n'$gameName)
fi
gameList[$gameName]="$winePath/Q9 Action Game/q9.exe"
fi

# River Raiders
gameName="River Raiders"
if [ -d "$winePath/x-sight interactive/River Raiders" ]; then
if [ -z "$gameMenu" ]; then
gameMenu=($gameName)
else
gameMenu=(${gameMenu[@]}$'\n'$gameName)
fi
gameList[$gameName]="$winePath/x-sight interactive/River Raiders/raid.exe"
fi

# R S Games
gameName="R S Games"
if [ -x "/usr/bin/rsgames" ]; then
if [ -z "$gameMenu" ]; then
gameMenu=($gameName)
else
gameMenu=(${gameMenu[@]}$'\n'$gameName)
fi
gameList[$gameName]="/usr/bin/rsgames"
fi

# Sound RTS
gameName="Sound RTS"
if [ -x "/usr/bin/soundrts" ]; then
if [ -z "$gameMenu" ]; then
gameMenu=($gameName)
else
gameMenu=(${gameMenu[@]}$'\n'$gameName)
fi
gameList[$gameName]="/usr/bin/soundrts"
fi

# Super Egg Hunt
gameName="Super Egg Hunt"
if [ -d "$winePath/Lworks/super egg hunt" ]; then
if [ -z "$gameMenu" ]; then
gameMenu=($gameName)
else
gameMenu=(${gameMenu[@]}$'\n'$gameName)
fi
gameList[$gameName]="$winePath/Lworks/super egg hunt/superegghunt.exe"
fi

# The Blind Swordsman
gameName="The Blind Swordsman"
if [ -f "$winePath/TheBlindSwordsman.exe" ]; then
if [ -z "$gameMenu" ]; then
gameMenu=($gameName)
else
gameMenu=(${gameMenu[@]}$'\n'$gameName)
fi
gameList[$gameName]="$winePath/TheBlindSwordsman.exe"
fi

# Top Speed 3
gameName="Top Speed 3"
if [ -d "$winePath/Playing in the dark/Top Speed 3" ]; then
if [ -z "$gameMenu" ]; then
gameMenu=($gameName)
else
gameMenu=(${gameMenu[@]}$'\n'$gameName)
fi
gameList[$gameName]="$winePath/Playing in the dark/Top Speed 3/TopSpeed.exe"
fi

# X-Wheel
gameName="X-Wheel"
if [ -d "$winePath/x-sight interactive/X-Wheel" ]; then
if [ -z "$gameMenu" ]; then
gameMenu=($gameName)
else
gameMenu=(${gameMenu[@]}$'\n'$gameName)
fi
gameList[$gameName]="$winePath/x-sight interactive/X-Wheel/x-wheel.exe"
fi

# Generate list of games, and launch selected game
game="$(zenity --list --title "Audio Game Launcher" --text "Select a game to play" --column "Select A Game" ${gameMenu[@]})"
if [ -n "$game" ]; then
if [ "${gameList[$game]}" != "${gameList[$game]/$winePath/}" ]; then
cd "${gameList[$game]%/*}"
wine "${gameList[$game]}"
else
${gameList[$game]}
fi
fi
IFS="$ifs"
exit 0
