#!/bin/bash

# ACPI plugin for Orca by Storm dragon: http://stormdragon.tk
# Released under the terms of the WTFPL: http://wtfpl.net

# Error codes:
# 1 Missing packages
# 2 ACPI did not return valid battery information.

if has acpi &> /dev/null ; then
echo "This plugin requires the package eh c p i to function. Please install eh c p i and try again."
exit 1
fi

info="$(acpi)"
remainingTime="$(echo "$info" | cut -d , -f3 | cut -d " " -f2)"
status="$(echo "$info" | cut -d : -f2 | cut -d , -f1 | tr -d "[:space:]")"
status="${status,}"
if [ "$status" = "unknown" ]; then
echo "Battery status unknown."
exit 2
fi
hours="$(echo "$remainingTime" | cut -d : -f1 | sed 's/^0//')"
minutes="$(echo "$remainingTime" | cut -d : -f2 | sed 's/^0//')"
seconds="$(echo "$remainingTime" | cut -d : -f3 | sed 's/^0//')"
if [[ "$hours" =~ ^[0-9]+$ ]] ; then
if [ $hours -eq 1 ]; then
hours="$hours hour"
else
hours="$hours hours"
fi
if [ $minutes -eq 1 ]; then
minutes="$minutes minute"
else
minutes="$minutes minutes"
fi
if [ $seconds -eq 1 ]; then
seconds="$seconds second"
else
seconds="$seconds seconds"
fi
fi
if [ "$status" = "discharging" ]; then
message="The battery is $status. $hours, $minutes and $seconds remaining."
else
message="The battery is $status. $hours, $minutes and $seconds until charged."
fi
echo "$message"
if hash xclip &> /dev/null ; then
echo "$message" | xclip -selection clipboard  2> /dev/null
fi
exit 0
