#!/bin/zsh
export disk=$1
if mountpoint -q /proc;then
sleep .01
else
mount -t proc /proc /proc
fi
if mountpoint -q /dev;then
sleep .01
else
mount -t devtmpfs /dev /dev
fi
if mountpoint -q /sys;then
sleep .01
else
mount -t sysfs /sys /sys
fi
if mountpoint -q /sys/firmware/efi/efivars;then
sleep .01
else
mount -t efivarfs /sys/firmware/efi/efivars /sys/firmware/efi/efivars
fi
if mountpoint -q /run;then
sleep .01
else
mount -t tmpfs -o mode=755 /run /run
fi
if [ -e /usr/lib/grub/i386-pc ];then
sleep .01
else
export grub_nobios=1
fi
if [ -e /usr/lib/grub/i386-efi ];then
sleep .01
else
export grub_noefi32=1
fi
if [ -e /usr/lib/grub/x86_64-efi ];then
sleep .01
else
export grub_noefi64=1
fi
if [ -e /usr/lib/grub/arm64-efi ];then
if [ $disk = "root_only" ];then
sleep .01
else
if [ -e /boot/vmlinuz-linux ];then
sleep .01
else
ln -s /boot/Image /boot/vmlinuz-linux
fi
fi
else
export grub_noefiarm64=1
fi
if [ -f /boot.old.tar.gz ];then
echo restoring old ESP content
cd /boot/EFI
tar -xf /boot.old.tar.gz
fi
passwd -l root
usermod -s /bin/zsh root
if cat /proc/cmdline|grep -q nospeech; then
rm -rf /etc/skel/.config/autostart/orca.desktop /etc/skel/.config/retroarch.accessibility /etc/skel/.zlogin.accessibility /etc/skel/.profile.accessibility /usr/share/origprofile/kodi/.kodi/addons/service.xbmc.tts
case "$2" in
base)
export services=`echo "avahi-daemon bluetooth brltty NetworkManager ntpd"`
for f in "/etc/skel/.zlogin" "/etc/skel/.profile";do
cat > $f <<EOF
source /etc/profile.d/*.sh
umask 077
export ACCESSIBILITY_ENABLED=1
export GTK_MODULES=gail:atk-bridge
export GNOME_ACCESSIBILITY=1
export QT_ACCESSIBILITY=1
export QT_LINUX_ACCESSIBILITY_ALWAYS_ON=1
export DTK_PROGRAM=espeak
export PATH=$PATH:/opt/android-sdk/platform-tools:/usr/bin/core_perl:~/bin
EOF
done
;;
basegui)
export services=`echo "avahi-daemon bluetooth brltty NetworkManager ntpd"`
for f in "/etc/skel/.zlogin" "/etc/skel/.profile";do
cat > $f <<EOF
source /etc/profile.d/*.sh
umask 077
export ACCESSIBILITY_ENABLED=1
export GTK_MODULES=gail:atk-bridge
export GNOME_ACCESSIBILITY=1
export QT_ACCESSIBILITY=1
export QT_LINUX_ACCESSIBILITY_ALWAYS_ON=1
export DTK_PROGRAM=espeak
export PATH=$PATH:/opt/android-sdk/platform-tools:/usr/bin/core_perl:~/bin
./applydef.sh
if tty|grep -qw pts;then
sleep .01
else
if is-x-running;then
sleep .01
else
startx
logout
fi
fi
EOF
done
echo ratpoison > /etc/skel/.xinitrc
;;
gnome)
export services=`echo "avahi-daemon bluetooth brltty cups-browsed ModemManager NetworkManager org.cups.cupsd systemd-timesyncd"`
for f in "/etc/skel/.zlogin" "/etc/skel/.profile";do
cat > $f <<EOF
source /etc/profile.d/*.sh
umask 077
export ACCESSIBILITY_ENABLED=1
export GTK_MODULES=gail:atk-bridge
export GNOME_ACCESSIBILITY=1
export QT_ACCESSIBILITY=1
export QT_LINUX_ACCESSIBILITY_ALWAYS_ON=1
export DTK_PROGRAM=espeak
export PATH=$PATH:/opt/android-sdk/platform-tools:/usr/bin/core_perl:~/bin
./applydef.sh
if tty|grep -qw pts;then
sleep .01
else
if is-x-running;then
sleep .01
else
startwl
logout
fi
fi
EOF
done
echo gnome-session --no-reexec > /etc/skel/.wldesktop
chmod 755 /etc/skel/.wldesktop
mkdir -p /etc/systemd/system/getty@.service.d
cat > /etc/systemd/system/getty@.service.d/wayland.conf<<EOF
[Service]
Environment=XDG_SESSION_TYPE=wayland
EOF
systemctl daemon-reload
;;
mate)
export services=`echo "avahi-daemon bluetooth brltty NetworkManager ntpd"`
for f in "/etc/skel/.zlogin" "/etc/skel/.profile";do
cat > $f <<EOF
source /etc/profile.d/*.sh
umask 077
export ACCESSIBILITY_ENABLED=1
export GTK_MODULES=gail:atk-bridge
export GNOME_ACCESSIBILITY=1
export QT_ACCESSIBILITY=1
export QT_LINUX_ACCESSIBILITY_ALWAYS_ON=1
export DTK_PROGRAM=espeak
export PATH=$PATH:/opt/android-sdk/platform-tools:/usr/bin/core_perl:~/bin
./applydef.sh
if tty|grep -qw pts;then
sleep .01
else
if is-x-running;then
sleep .01
else
startx
logout
fi
fi
EOF
done
echo mate-session > /etc/skel/.xinitrc
;;
plasma)
export services=`echo "avahi-daemon bluetooth brltty NetworkManager ntpd"`
for f in "/etc/skel/.zlogin" "/etc/skel/.profile";do
cat > $f <<EOF
source /etc/profile.d/*.sh
umask 077
export ACCESSIBILITY_ENABLED=1
export GTK_MODULES=gail:atk-bridge
export GNOME_ACCESSIBILITY=1
export QT_ACCESSIBILITY=1
export QT_LINUX_ACCESSIBILITY_ALWAYS_ON=1
export DTK_PROGRAM=espeak
export SAL_USE_VCLPLUGIN=gtk3
export PATH=$PATH:/opt/android-sdk/platform-tools:/usr/bin/core_perl:~/bin
./applydef.sh
if tty|grep -qw pts;then
sleep .01
else
if is-x-running;then
sleep .01
else
startx
logout
fi
fi
EOF
done
echo startplasma-x11 > /etc/skel/.xinitrc
;;
kodi)
export nouser=1
if [ -e /usr/lib/systemd/system/kodi.service ];then
export services=`echo "avahi-daemon kodi NetworkManager ntpd sshd wpa_supplicant"`
else
export services=`echo "avahi-daemon kodi-x11 NetworkManager ntpd sshd wpa_supplicant"`
fi
useradd -r -d /var/lib/kodi kodi
export pass=$RANDOM$RANDOM
echo $pass > /defpass
echo the default password for the kodi user, which will allow administrative access to this system, is $pass". It has been saved in a file called /defpass. This password can be changed anytime through your ssh console by running: passwd kodi"
passwd kodi<<EOF
$pass
$pass
EOF
chown root:root /defpass
chmod 600 /defpass
echo setting group ownership...
usermod -a -G wheel,audio,video,network,storage,optical,kodi kodi
echo setting kodi user to use bash as login shell...
usermod -s /bin/bash kodi
factory-reset
;;
retroarch)
export nouser=1
export services=`echo "avahi-daemon NetworkManager ntpd sshd wpa_supplicant"`
for f in "/etc/skel/.zlogin" "/etc/skel/.profile";do
cat > $f <<EOF
source /etc/profile.d/*.sh
umask 077
export ACCESSIBILITY_ENABLED=1
export GTK_MODULES=gail:atk-bridge
export GNOME_ACCESSIBILITY=1
export QT_ACCESSIBILITY=1
export QT_LINUX_ACCESSIBILITY_ALWAYS_ON=1
export DTK_PROGRAM=espeak
export PATH=$PATH:/opt/android-sdk/platform-tools:/usr/bin/core_perl:~/bin
./applydef.sh
if tty|grep -qw pts;then
sleep .01
else
if is-x-running;then
sleep .01
else
startx
logout
fi
fi
EOF
done
echo ratpoison >> /etc/skel/.xinitrc
echo 'exec sh -c "retroarch;killall ratpoison"' >> /etc/skel/.ratpoisonrc
for n in "1" "2" "3" "4" "5" "6";do
mkdir -p /etc/systemd/system/getty@tty$n.service.d
cat > /etc/systemd/system/getty@tty$n.service.d/retroarch.conf<<EOF
[Service]
ExecStart=-/sbin/agetty -a retroarch --noclear --nohostname --nonewline %I \$TERM
EOF
done
cp /lib/systemd/system/getty@.service /lib/systemd/system/getty@.service.sys
sed -i /ExecStart/d /lib/systemd/system/getty@.service
useradd -m -r -d /var/lib/retroarch retroarch
export pass=$RANDOM$RANDOM
echo $pass > /defpass
echo the default password for the retroarch user, which will allow administrative access to this system, is $pass". It has been saved in a file called /defpass. This password can be changed anytime through your ssh console by running: passwd retroarch"
passwd retroarch<<EOF
$pass
$pass
EOF
chown root:root /defpass
chmod 600 /defpass
echo setting group ownership...
cp -rf /usr/share/libretro/* /var/lib/retroarch/.config/retroarch
usermod -a -G wheel,audio,video,network,storage,optical,retroarch retroarch
chown -R retroarch:retroarch /var/lib/retroarch
echo setting retroarch user to use zsh as login shell...
usermod -s /bin/zsh retroarch
;;
all)
export services=`echo "avahi-daemon bluetooth cups-browsed ModemManager NetworkManager org.cups.cupsd systemd-timesyncd"`
for f in "/etc/skel/.zlogin" "/etc/skel/.profile";do
cat > $f <<EOF
source /etc/profile.d/*.sh
umask 077
export ACCESSIBILITY_ENABLED=1
export GTK_MODULES=gail:atk-bridge
export GNOME_ACCESSIBILITY=1
export QT_ACCESSIBILITY=1
export QT_LINUX_ACCESSIBILITY_ALWAYS_ON=1
export DTK_PROGRAM=espeak
export PATH=$PATH:/opt/android-sdk/platform-tools:/usr/bin/core_perl:~/bin
./applydef.sh
if tty|grep -qw pts;then
sleep .01
else
if is-x-running;then
sleep .01
else
startx
logout
fi
fi
EOF
done
;;
esac
else
case "$2" in
base)
export services=`echo "avahi-daemon bluetooth brltty espeakup NetworkManager ntpd"`
for f in "/etc/skel/.zlogin" "/etc/skel/.profile";do
cat > $f <<EOF
source /etc/profile.d/*.sh
umask 077
export ACCESSIBILITY_ENABLED=1
export GTK_MODULES=gail:atk-bridge
export GNOME_ACCESSIBILITY=1
export QT_ACCESSIBILITY=1
export QT_LINUX_ACCESSIBILITY_ALWAYS_ON=1
export DTK_PROGRAM=espeak
if tty|grep -qw pts;then
sleep .01
else
sudo speechctl stop
sudo speechctl start
fi
EOF
done
;;
basegui)
export services=`echo "avahi-daemon bluetooth espeakup NetworkManager ntpd"`
for f in "/etc/skel/.zlogin" "/etc/skel/.profile";do
cat > $f <<EOF
source /etc/profile.d/*.sh
umask 077
export ACCESSIBILITY_ENABLED=1
export GTK_MODULES=gail:atk-bridge
export GNOME_ACCESSIBILITY=1
export QT_ACCESSIBILITY=1
export QT_LINUX_ACCESSIBILITY_ALWAYS_ON=1
export DTK_PROGRAM=espeak
export PATH=$PATH:/opt/android-sdk/platform-tools:/usr/bin/core_perl:~/bin
./applydef.sh
if tty|grep -qw pts;then
sleep .01
else
if is-x-running;then
sleep .01
else
sudo speechctl stop
startx
sudo speechctl start
logout
fi
fi
EOF
done
echo ratpoison > /etc/skel/.xinitrc
;;
gnome)
export services=`echo "avahi-daemon bluetooth espeakup NetworkManager ntpd"`
for f in "/etc/skel/.zlogin" "/etc/skel/.profile";do
cat > $f <<EOF
source /etc/profile.d/*.sh
umask 077
export ACCESSIBILITY_ENABLED=1
export GTK_MODULES=gail:atk-bridge
export GNOME_ACCESSIBILITY=1
export QT_ACCESSIBILITY=1
export QT_LINUX_ACCESSIBILITY_ALWAYS_ON=1
export DTK_PROGRAM=espeak
export PATH=$PATH:/opt/android-sdk/platform-tools:/usr/bin/core_perl:~/bin
./applydef.sh
if tty|grep -qw pts;then
sleep .01
else
if is-x-running;then
sleep .01
else
sudo speechctl stop
startwl
sudo speechctl start
logout
fi
fi
EOF
done
echo gnome-session --no-reexec > /etc/skel/.wldesktop
chmod 755 /etc/skel/.wldesktop
mkdir -p /etc/systemd/system/getty@.service.d
cat > /etc/systemd/system/getty@.service.d/wayland.conf<<EOF
[Service]
Environment=XDG_SESSION_TYPE=wayland
EOF
systemctl daemon-reload
;;
mate)
export services=`echo "avahi-daemon bluetooth espeakup NetworkManager ntpd"`
for f in "/etc/skel/.zlogin" "/etc/skel/.profile";do
cat > $f <<EOF
source /etc/profile.d/*.sh
umask 077
export ACCESSIBILITY_ENABLED=1
export GTK_MODULES=gail:atk-bridge
export GNOME_ACCESSIBILITY=1
export QT_ACCESSIBILITY=1
export QT_LINUX_ACCESSIBILITY_ALWAYS_ON=1
export DTK_PROGRAM=espeak
export PATH=$PATH:/opt/android-sdk/platform-tools:/usr/bin/core_perl:~/bin
./applydef.sh
if tty|grep -qw pts;then
sleep .01
else
if is-x-running;then
sleep .01
else
sudo speechctl stop
startx
sudo speechctl start
logout
fi
fi
EOF
done
echo  mate-session > /etc/skel/.xinitrc
;;
plasma)
export services=`echo "avahi-daemon bluetooth espeakup NetworkManager ntpd"`
for f in "/etc/skel/.zlogin" "/etc/skel/.profile";do
cat > $f <<EOF
source /etc/profile.d/*.sh
umask 077
export ACCESSIBILITY_ENABLED=1
export GTK_MODULES=gail:atk-bridge
export GNOME_ACCESSIBILITY=1
export QT_ACCESSIBILITY=1
export QT_LINUX_ACCESSIBILITY_ALWAYS_ON=1
export DTK_PROGRAM=espeak
export SAL_USE_VCLPLUGIN=gtk3
export PATH=$PATH:/opt/android-sdk/platform-tools:/usr/bin/core_perl:~/bin
./applydef.sh
if tty|grep -qw pts;then
sleep .01
else
if is-x-running;then
sleep .01
else
sudo speechctl stop
startx
sudo speechctl start
logout
fi
fi
EOF
done
echo startplasma-x11 > /etc/skel/.xinitrc
;;
kodi)
export nouser=1
if [ -e /usr/lib/systemd/system/kodi.service ];then
export services=`echo "avahi-daemon kodi NetworkManager ntpd sshd wpa_supplicant"`
else
export services=`echo "avahi-daemon kodi-x11 NetworkManager ntpd sshd wpa_supplicant"`
fi
useradd -r -d /var/lib/kodi kodi
export pass=$RANDOM$RANDOM
echo $pass > /defpass
echo the default password for the kodi user, which will allow administrative access to this system, is $pass". It has been saved in a file called /defpass. This password can be changed anytime through your ssh console by running: passwd kodi"
passwd kodi<<EOF
$pass
$pass
EOF
chown root:root /defpass
chmod 600 /defpass
echo setting group ownership...
usermod -a -G wheel,audio,video,network,storage,optical,kodi kodi
echo setting kodi user to use bash as login shell...
usermod -s /bin/bash kodi
factory-reset
;;
retroarch)
export nouser=1
export services=`echo "avahi-daemon NetworkManager ntpd sshd wpa_supplicant"`
rm -rf /etc/skel/.config/retroarch
mv /etc/skel/.config/retroarch.accessibility /etc/skel/.config/retroarch
for f in "/etc/skel/.zlogin" "/etc/skel/.profile";do
cat > $f <<EOF
source /etc/profile.d/*.sh
umask 077
export ACCESSIBILITY_ENABLED=1
export GTK_MODULES=gail:atk-bridge
export GNOME_ACCESSIBILITY=1
export QT_ACCESSIBILITY=1
export QT_LINUX_ACCESSIBILITY_ALWAYS_ON=1
export DTK_PROGRAM=espeak
export PATH=$PATH:/opt/android-sdk/platform-tools:/usr/bin/core_perl:~/bin
./applydef.sh
if tty|grep -qw pts;then
sleep .01
else
if is-x-running;then
sleep .01
else
startx
logout
fi
fi
EOF
done
echo ratpoison >> /etc/skel/.xinitrc
echo 'exec sh -c "retroarch;killall ratpoison"' >> /etc/skel/.ratpoisonrc
for n in "1" "2" "3" "4" "5" "6";do
mkdir -p /etc/systemd/system/getty@tty$n.service.d
cat > /etc/systemd/system/getty@tty$n.service.d/retroarch.conf<<EOF
[Service]
ExecStart=-/sbin/agetty -a retroarch --noclear --nohostname --nonewline %I \$TERM
EOF
done
cp /lib/systemd/system/getty@.service /lib/systemd/system/getty@.service.sys
sed -i /ExecStart/d /lib/systemd/system/getty@.service
useradd -m -r -d /var/lib/retroarch retroarch
export pass=$RANDOM$RANDOM
echo $pass > /defpass
echo the default password for the retroarch user, which will allow administrative access to this system, is $pass". It has been saved in a file called /defpass. This password can be changed anytime through your ssh console by running: passwd retroarch"
passwd retroarch<<EOF
$pass
$pass
EOF
chown root:root /defpass
chmod 600 /defpass
echo setting group ownership...
cp -rf /usr/share/libretro/* /var/lib/retroarch/.config/retroarch
usermod -a -G wheel,audio,video,network,storage,optical,retroarch retroarch
chown -R retroarch:retroarch /var/lib/retroarch
echo setting retroarch user to use zsh as login shell...
usermod -s /bin/zsh retroarch
;;
all)
export services=`echo "avahi-daemon bluetooth brltty cups-browsed espeakup ModemManager NetworkManager org.cups.cupsd systemd-timesyncd"`
for f in "/etc/skel/.zlogin" "/etc/skel/.profile";do
cat > $f <<EOF
source /etc/profile.d/*.sh
umask 077
export ACCESSIBILITY_ENABLED=1
export GTK_MODULES=gail:atk-bridge
export GNOME_ACCESSIBILITY=1
export QT_ACCESSIBILITY=1
export QT_LINUX_ACCESSIBILITY_ALWAYS_ON=1
export DTK_PROGRAM=espeak
export PATH=$PATH:/opt/android-sdk/platform-tools:/usr/bin/core_perl:~/bin
./applydef.sh
if tty|grep -qw pts;then
sleep .01
else
if is-x-running;then
sleep .01
else
sudo speechctl stop
startx
sudo speechctl start
logout
fi
fi
EOF
done
;;
esac
cat /proc/cmdline|tr \  \\n|grep reader=|sed "s|reader=||g"|tr -d \\n|read -r -s reader
case "$reader" in
espeakup)
for f in "/etc/skel/.zlogin" "/etc/skel/.profile" "/usr/bin/firstboot";do
sed -i "s|speechctl stop|speechctl stop espeakup|g;s|speechctl start|speechctl start espeakup|g;s|speechctl restart|speechctl restart espeakup|g;s|systemctl enable fenrirscreenreader speech-dispatcherd|systemctl enable espeakup|g;s|systemctl disable fenrirscreenreader speech-dispatcherd|systemctl disable espeakup|g;s|\/etc\/systemd\/system\/getty.target.wants\/fenrirscreenreader.service|\/etc\/systemd\/system\/sound.target.wants\/espeakup.service|g;s|pgrep fenrir|pgrep espeakup|g" $f
done
;;
fenrir)
export services=`echo -n $services|sed "s| espeakup | fenrirscreenreader speech-dispatcherd |g"`
;;
speechd-up)
for f in "/etc/skel/.zlogin" "/etc/skel/.profile" "/usr/bin/firstboot";do
sed -i "s|speechctl stop|speechctl stop speechd-up|g;s|speechctl start|speechctl start speechd-up|g;s|speechctl restart|speechctl restart speechd-up|g;s|systemctl enable fenrirscreenreader speech-dispatcherd|systemctl enable speech-dispatcherd speechd-up|g;s|systemctl disable fenrirscreenreader speech-dispatcherd|systemctl disable speech-dispatcherd speechd-up|g;s|\/etc\/systemd\/system\/getty.target.wants\/fenrirscreenreader.service|\/etc\/systemd\/system\/sound.target.wants\/speechd-up.service|g;s|pgrep fenrir|pgrep speechd-up|g" $f
done
export services=`echo -n $services|sed "s| espeakup | speech-dispatcherd speechd-up |g"`
;;
*)
export services=`echo -n $services|sed "s| espeakup | fenrirscreenreader speech-dispatcherd |g"`
;;
esac
fi
if echo $nouser|grep -qw 1;then
sleep .01
else
echo preparing for first boot
mkdir -p /etc/systemd/system/getty@tty1.service.d
cat > /etc/systemd/system/getty@tty1.service.d/firstboot.conf<<EOF
[Service]
ExecStart=-/sbin/agetty -a root --noclear --nohostname --nonewline %I \$TERM
EOF
cp /lib/systemd/system/getty@.service /lib/systemd/system/getty@.service.sys
sed -i /ExecStart/d /lib/systemd/system/getty@.service
cat > ~/.zshrc.local<<EOF
export preset=$2
while true;do
if firstboot \$preset;then
systemctl daemon-reload
clear
break
else
continue
fi
done
logout
EOF
fi
if [ $disk = "root_only" ];then
export grub_nobios=1
export grub_noefi32=1
export grub_noefi64=1
export grub_noefiarm64=1
echo root only install requested, not installing bootloader
else
if df -h /|tail -n 1|cut -f 1 -d \  |grep -q /dev/mapper;then
if [ -e /crypto_keyfile.bin ];then
sleep .01
else
echo generating crypto key for automatic unlock after load of kernel and ramdisk
echo > /crypto_keyfile.bin
chown root:root /crypto_keyfile.bin
chmod 600 /crypto_keyfile.bin
dd if=/dev/random of=/crypto_keyfile.bin bs=1M count=8
fi
echo "root is encrypted, regenerating initcpios..."
mv /etc/mkinitcpio.conf.encrypted /etc/mkinitcpio.conf
mv /etc/default/grub.encrypted /etc/default/grub
mkinitcpio -P
else
rm /etc/mkinitcpio.conf.encrypted /etc/default/grub.encrypted
echo "regenerating initcpios for hibernation support..."
mkinitcpio -P
fi
cd /
echo "installing grub boot loader... "
if [ -z $grub_nobios ];then
grub-install --target i386-pc $disk
fi
if [ -z $grub_noefi32 ];then
grub-install --no-nvram --target i386-efi $disk
fi
if [ -z $grub_noefi64 ];then
grub-install --no-nvram --target x86_64-efi $disk
fi
if [ -z $grub_noefiarm64 ];then
grub-install --no-nvram --target arm64-efi $disk
fi
if [ -e /boot/EFI/boot/bootx64.efi ];then
mv /boot/EFI/boot/bootx64.efi /boot/EFI/boot/bootx64.efi.old
fi
if [ -e /usr/share/shim-signed/EFI/boot ];then
cp -rf /usr/share/shim-signed/EFI /boot/EFI/
fi
echo "making bootloader configuration file... "
grub-mkconfig -o /boot/grub/grub.cfg
echo enabling secure boot support
bootcrypt
fi
echo "Default system time will be in UTC, set to your desired timezone in your desktop environment or by running: ln -s /usr/share/zoneinfo/timezone_designation, such as /usr/share/zoneinfo/America/New_York."
echo "generating system locale definitions"
locale-gen
echo "enabling services"
for s in `echo $services`;do
if [ -f /usr/lib/systemd/system/$s.service ];then
systemctl enable $s
fi
done
echo "complete! your system is set up and ready for you to use! Enjoy your jenux system! "
rm /etc/postinstall.sh
exit 0
