#!/bin/zsh
if [ -e /etc/grub.d/10_linux  ];then
rm /etc/grub.d/10_linux
fi
if [ -f /boot.old.tar.gz ];then
echo restoring old ESP content
cd /boot
tar -xf /boot.old.tar.gz
fi
read disk </disk
usermod -s /bin/zsh root
locale-gen
for f in "1" "2" "3" "4" "5" "6";do
systemctl enable getty@tty$f > /dev/null 2>/dev/null
done
if [ -e /usr/lib/grub/i386-pc ];then
sleep .01
else
export grub_nobios=1
fi
if [ -e /usr/lib/grub/i386-efi ];then
sleep .01
else
export grub_noefi32=1
fi
if [ -e /usr/lib/grub/x86_64-efi ];then
sleep .01
else
export grub_noefi64=1
fi
echo "installing grub boot loader... "
if [ -z $grub_nobios ];then
export disk=$1
grub-install --target i386-pc $disk
fi
if [ -z $grub_noefi32 ];then
grub-install --no-nvram --target i386-efi $disk
fi
if [ -z $grub_noefi64 ];then
grub-install --no-nvram --target x86_64-efi $disk
fi
if [ -e /boot/EFI/boot/bootx64.efi ];then
mv /boot/EFI/boot/bootx64.efi /boot/EFI/boot/bootx64.efi.old
fi
echo "installing android... "
iso2access /android.iso $disk
echo enabling secure boot support
bootcrypt
if [ -e /usr/share/shim-signed/EFI/boot ];then
cp -rf /usr/share/shim-signed/EFI /boot/EFI/
fi
echo setting up recovery login
mkdir -p /etc/systemd/system/getty@tty1.service.d
echo \[Service\] > /etc/systemd/system/getty@tty1.service.d/recovery.conf
echo ExecStart= >> /etc/systemd/system/getty@tty1.service.d/recovery.conf
echo ExecStart=-/sbin/agetty -a root --noclear --nohostname --nonewline %I \$TERM >> /etc/systemd/system/getty@tty1.service.d/recovery.conf
cp /lib/systemd/system/getty@.service /lib/systemd/system/getty@.service.sys
sed -i /ExecStart/d /lib/systemd/system/getty@.service
rm /etc/postinstall.sh
exit 0
